import { getTranslations } from "next-intl/server";
import Link from "next/link";
import { FaArrowRight } from "react-icons/fa";
import FallbackImage from "../shared/FallbackImage";
const BlogCard = async ({ blog }) => {
  const t = await getTranslations("single-article");

  return (
    <div className="bg-white">
      <div className="">
        <FallbackImage width={600} height={300} src={blog.image} alt={blog.title} className="object-cover w-full h-36 md:h-64" />
      </div>
      <div className=" p-3 md:p-6 space-y-4">
        <div className="">
          <Link href={`/articles/${blog.id}`} className="text-xl font-bold line-clamp-1 hover:text-main">{blog.title}</Link>
          <Link href={`/categoryblogs/${blog.cat_id}`} className="text-lg block text-main">{blog.cat_name}</Link>
        </div>
        <div className="line-clamp-2 text-secondary leading-loose"
          dangerouslySetInnerHTML={{
            __html: blog.excerpt || "",
          }}
        ></div>
        {/* </p> */}
        <div className="flex items-center justify-between ">
          {/* auth */}
          <div className="flex items-center  gap-2">
            <FallbackImage
              src={blog.owner_image}
              width={40}
              height={40}
              alt={blog.owner}
              placeholderSrc="/user/profileplaceholder.jpeg"
              className="rounded-full"
            />
            <div>
              <p className="text-sm">{t("by")}</p>
              <p className="font-bold">{blog.owner}</p>
            </div>
          </div>
          {/* link */}
          <Link
            href={`/articles/${blog.id}`}
            className="border-b border-black flex  items-center gap-2 text-sm font-bold w-fit px-2 py-4 hover:bg-black hover:text-white transition-all duration-300 mx-auto lg:mx-0"
          >
            <FaArrowRight size={16} />
            {t("readMore")}
          </Link>
        </div>
      </div>
    </div>
  );
};

export default BlogCard;
