import fetchData from "@/api/fetch-data";
import { getLocale } from "next-intl/server";
import BlogCardRedesignThree from "../shared/BlogCardRedesignThree/BlogCardRedesignThree";
import SectionHeader from "../shared/SectionHeader";

const Blogs = async () => {
  const locale = await getLocale();
  let blogs = [];
  const response = await fetchData({ endPoint: "/articles" });
  if (response.status == "success") {
    blogs = response?.data?.articles?.slice(0, 3);
  }
  return blogs?.length > 0 ? (
    <div className="container space-y-6">
      <SectionHeader
        title={locale == "ar" ? "أهم" : "Important"}
        marker={locale == "ar" ? "المقالات" : "articles"}
        link="/articles"
      />
      <div className="grid grid-cols-1 gap-2 sm:grid-cols-2 md:grid-cols-3">
        {blogs?.map((item, index) => (
          <div key={index}>
            <BlogCardRedesignThree blog={item} />
          </div>
        ))}
      </div>
    </div>
  ) : null;
};

export default Blogs;
