"use client";
import { categories } from "@/api/categories/Categories";
import {
  Carousel,
  CarouselContent,
  CarouselItem,
} from "@/components/ui/carousel";
import { useSettings } from "@/stores/settings";
import clsx from "clsx";
import Autoplay from "embla-carousel-autoplay";
import { useLocale } from "next-intl";
import { useEffect, useState } from 'react';
import BrandCatCard from "../shared/BrandCatCard";
import SectionHeader from "../shared/SectionHeader";


const BrandSlider = ({ brands }) => {
  const locale = useLocale()
  const [api, setApi] = useState();
  const [currentSlide, setCurrentSlide] = useState(0);
  const [totalSlides, setTotalSlides] = useState(0);
  const { settings } = useSettings();
  // shadcn ui curasol dots
  useEffect(() => {
    if (!api) {
      return;
    }
    setTotalSlides(api.slideNodes().length);
    api.on("select", () => {
      setCurrentSlide(api.selectedScrollSnap())
    })
  }, [api])



  return (
    <div className="container">
      {brands && brands.length > 0 && settings?.site_settings?.show_brands == 1 ?
        <>
          <SectionHeader title={locale == "ar" ? "تسوق حسب" : "shop by"}
            marker={locale == "ar" ? "العلامات التجارية" : "brands"} withLink={true} link={"/brands"} />

          <div className=" my-8">
            <Carousel
              className="w-full "
              setApi={setApi}
              dir="ltr"
              opts={{
                loop: true,
                watchSlides: false,
                align: "start",
              }}
              plugins={[
                Autoplay({
                  delay: 3500,
                }),
              ]}
            >
              <CarouselContent >
                {brands.map((item, index) => {
                  const styleData = categories[index % categories.length];
                  return (
                    <CarouselItem key={item.id || index} className="basis-1/2 lg:basis-1/3 ">
                      <BrandCatCard
                        key={item.id}
                        item={item}
                        styleData={styleData}
                        imageClass="max-md:w-24 max-md:h-24"
                        isBrand={true}
                      />
                    </CarouselItem>
                  );
                })}
              </CarouselContent>
              <div className="flex justify-center mt-4 gap-2 overflow-x-auto pb-2">
                {Array.from({ length: totalSlides }).map((_, index) => (
                  <button
                    key={index}
                    className={clsx(`size-2 rounded-sm bg-gray-400 transition-all duration-300 flex-shrink-0`, {
                      'bg-main h-2 w-8': index === currentSlide,
                    })}
                    onClick={() => api?.scrollTo(index)}
                  />
                ))}
              </div>
            </Carousel>
          </div>
        </> : ""
      }

    </div>
  );
};

export default BrandSlider;







