"use client";
import { Card } from "@/components/ui/card";
import {
  Carousel,
  CarouselContent,
  CarouselItem
} from "@/components/ui/carousel";
import Autoplay from "embla-carousel-autoplay";
import Link from "next/link";
import FallbackImage from "../shared/FallbackImage";

export default function CategoriesCarousel({ tabs }) {
  return tabs && tabs.length > 0 ? (
    <Carousel
      opts={{
        loop: true,
        align: "start",
        dragFree: true,
      }}
      dir="ltr"
      plugins={[
        Autoplay({
          delay: 3000,
          stopOnMouseEnter: true,
          stopOnInteraction: false,
        }),
      ]}
      className="container"
    >
      <CarouselContent>
        {tabs?.map((tab, index) => (
          <CarouselItem
            key={index}
            className=" basis-1/2 md:basis-1/3 lg:basis-1/5 "
          >
            <Card className="hover:border-main transition-all duration-200 group">
              <Link
                className="flex gap-2 justify-center items-center lg:py-8 md:py-6 py-4"
                href={`/products/filter/${tab.id}`}
              >
                <div className="lg:size-12 md:size-10 size-8  relative">
                  <FallbackImage
                    src={tab.cover_image}
                    alt={tab.title || "Category"}
                    fill
                    className="object-contain"
                  />
                </div>
                <p className="lg:text-2xl text-lg line-clamp-1 group-hover:text-main transition-all duration-200">
                  {tab.title}
                </p>
              </Link>
            </Card>
          </CarouselItem>
        ))}
      </CarouselContent>
    </Carousel>
  ) : null;
}
