"use client";
import { useTranslations } from "next-intl";
import { useState, useEffect } from "react";
import Countdown from "react-countdown";

const CountdownTimer = ({ date }) => {
  const [isClient, setIsClient] = useState(false);
  const o = useTranslations("offers")

  // التأكد من أن المكون يتم تحميله فقط في العميل
  useEffect(() => {
    setIsClient(true);
  }, []);

  // ضبط التاريخ النهائي إلى 4 نوفمبر 2024
  const targetDate = new Date(date);

  // دالة لتنسيق العرض عند الانتهاء
  const Completionist = () => (
    <span className="text-2xl font-bold">{o("ended")}</span>
  );

  // دالة لتنسيق العرض أثناء العد التنازلي
  const renderer = ({ days, hours, minutes, seconds, completed }) => {
    if (completed) {
      return <Completionist />;
    } else {
      // العرض أثناء العد التنازلي
      return (
        <div className="text-center flex items-center gap-4 text-white">
          <h4 className="md:text-xl font-semibold">{o("endDate")}</h4>
          <span className="md:text-xl font-bold" dir="ltr">
            {days} : {hours} : {minutes} : {seconds}
          </span>
        </div>
      );
    }
  };

  // تأكد من أن العد التنازلي يظهر فقط بعد التأكد أن المكون يتم تحميله على العميل
  if (!isClient) {
    return null;
  }

  return (
    <div className="bg-main md:p-6 p-2  rounded-lg flex items-center justify-center">
      <Countdown date={targetDate} renderer={renderer} />
    </div>
  );
};

export default CountdownTimer;
