import Link from "next/link";
import { FaArrowRight } from "react-icons/fa";
import FallbackImage from "../shared/FallbackImage";
const FirstBanner = () => {
  const s = useTranslations('shared')

  return (
    <div className="container bg-light lg:p-10 p-6 flex flex-col lg:flex-row items-center justify-between lg:gap-12 gap-2 ">
      <FallbackImage
        src={"/home/firstbanner.png"}
        alt="banner"
        width={250}
        height={250}
      />
      <Link
        href="#"
        className="border-b border-black flex items-center gap-2 font-bold w-fit p-4 hover:bg-black hover:text-light transition-all duration-300"
      >
        <FaArrowRight size={16} />
        {t('shaping-now')}
      </Link>
    </div>
  );
};

export default FirstBanner;
