import { products } from "@/api/products";
import { Separator } from "@/components/ui/separator";
import FallbackImage from "../shared/FallbackImage";

export default async function LatestProducts() {
  return (
    <div className="grid grid-cols-12 gap-4 bg-white p-4 ">
      {products.map((item, index) => (
        <div key={index} className="col-span-12 ">
          <div className="flex items-center gap-2">
            <FallbackImage
              src={item.img || ""}
              alt={item.title}
              width={75}
              height={75}
            />
            <div className="space-y-4">
              <h3 className=" font-semibold">{item.title}</h3>
              <p className=" font-bold space-x-2">
                <del className="text-sm text-gray-400">
                  {item.preSale}
                </del>
                ج.م{item.onSale}{" "}
              </p>
            </div>
          </div>
          <Separator className="mt-4" />
        </div>
      ))}
    </div>
  );
}