import fetchData from "@/api/fetch-data";
import { getLocale } from "next-intl/server";
import Link from "next/link";
import FallbackImage from "../../shared/FallbackImage";
import SectionHeader from "../../shared/SectionHeader";
const LightBlueCategories = async () => {
  const locale = await getLocale();

  let tabs;
  const response = await fetchData({
    endPoint: "/categories",
    locale: locale,
  });
  if (response.status == "success") {
    tabs = response.data;
  } else {
    tabs = [];
  }
  return (
    <>
      {tabs && tabs.length > 0 ? (
        <div className="container">
          <SectionHeader
            title={locale == "en" ? "Shop Our " : "تسوق"}
            marker={locale == "en" ? "Categories" : "أقسامنا"}
            withLink={false}
          />
          <div className=" py-2 md:py-4 flex items-center  overflow-x-auto gap-4 min-w-screen ">
            {tabs?.map((tap, index) => (
              <Link
                href={`/products/filter/${tap.id}`}
                key={index}
                className="text-sm bg-white hover:bg-lightmain  rounded-md shadow h-36 min-w-36 flex items-center justify-center"
              >
                <div className="text-center px-4">
                  <FallbackImage
                    src={tap.image}
                    alt={tap.title}
                    width={30}
                    height={30}
                    className="mx-auto mb-2"
                  />
                  {tap.title}
                </div>
              </Link>
            ))}
          </div>
        </div>
      ) : null}
    </>
  );
};

export default LightBlueCategories;
