"use client";
import fetchData from "@/api/fetch-data";
import {
  Carousel,
  CarouselContent,
  CarouselItem
} from "@/components/ui/carousel";
import useWishlistStore from "@/stores/wishlist";
import clsx from "clsx";
import Autoplay from "embla-carousel-autoplay";
import { useLocale, useTranslations } from "next-intl";
import Link from "next/link";
import { useEffect, useState } from "react";
import FallbackImage from "../shared/FallbackImage";

const backgroundSliderColors = [
  '#192C57',
  '#2C2C46',
  '#000000',
]


const MainSlider = ({ sliderArray }) => {
  const locale = useLocale();
  const t = useTranslations("shared");
  const [api, setApi] = useState();
  const [currentSlide, setCurrentSlide] = useState(0);
  const [totalSlides, setTotalSlides] = useState();
  const { setWishlistFromAPI } = useWishlistStore();

  useEffect(() => {
    async function fetchWishlist() {
      const response = await fetchData({
        endPoint: "/user/favourites",
      });
      setWishlistFromAPI(response.data); // Update Zustand store with API data
    }
    fetchWishlist();
    if (!api) {
      return;
    }
    setTotalSlides(api.slideNodes().length);
    api.on("select", () => {
      setCurrentSlide(api.selectedScrollSnap());
    });
  }, [api, setWishlistFromAPI]);

  return sliderArray?.length > 0 ? (
    <div className="container ">
      <Carousel
        className="w-full relative"
        setApi={setApi}
        dir="ltr"
        opts={{
          loop: true,
        }}
        plugins={[
          Autoplay({
            delay: 3000,
          }),
        ]}
      >
        <CarouselContent>
          {sliderArray.map((item, index) => (
            <CarouselItem key={index} className="basis-full">
              <div dir={locale == "ar" ? "rtl" : "ltr"}>
                <div style={{ backgroundColor: backgroundSliderColors[index % backgroundSliderColors.length] }} className=" py-6 lg:px-24 px-6 rounded-2xl bg-[url('/home/victor.svg')] bg-no-repeat md:bg-contain bg-cover bg-right-top ">
                  <div className="flex items-center md:flex-row flex-col lg:gap-6 gap-4 ">
                    {/* image */}
                    <div className="md:w-80 lg:h-96 md:h-80 relative">
                      <FallbackImage
                        src={item?.image}
                        alt={item?.data[0]?.name}
                        fill
                        className="object-contain"
                      />
                    </div>
                    {/* content */}
                    <div className="text-white  md:text-start text-center space-y-6">
                      <h2 className="m-0 lg:text-2xl text-lg">
                        {item?.data[0]?.name}{" "}
                      </h2>
                      <h2 className="lg:text-5xl text-2xl font-bold m-0">
                        {item?.data[0]?.description}
                      </h2>
                      <Link
                        href={item?.url}
                        className="btn btn-main block w-fit text-base mx-auto md:mx-0"
                      >
                        {t("shaping-now")}
                      </Link>
                    </div>
                  </div>
                </div>
              </div>
            </CarouselItem>
          ))}
        </CarouselContent>
        <div
          className={`flex justify-center mt-4 gap-2 overflow-x-auto pb-2 lg:absolute bottom-10 ${locale == "ar" ? "left-10" : "right-10"
            }`}
        >
          {Array.from({ length: totalSlides }).map((_, index) => (
            <button
              key={index}
              className={clsx(
                `size-4 rounded-full  transition-all duration-300 flex-shrink-0  hover:w-10 hover:h-4 hover:bg-main `,
                {
                  "h-4 w-10 bg-main": index == currentSlide,
                  "md:bg-white": index != currentSlide,
                }
              )}
              onClick={() => api?.scrollTo(index)}
            />
          ))}
        </div>
      </Carousel>
    </div>
  ) : (
    <></>
  );
};

export default MainSlider;
