"use client";
import { useToast } from "@/hooks/use-toast";
import useCart from "@/stores/cart";
import Link from "next/link";
import { useState } from "react";
import { FaCheckCircle } from "react-icons/fa";
import { IoMdHeart } from "react-icons/io"; // تغيير الاستيراد
import { IoStar } from "react-icons/io5";
import { TbShoppingBagPlus } from "react-icons/tb";
import FallbackImage from "../shared/FallbackImage";
import { getQueryClient } from "@/app/get-query-client";
import { useLocale } from "next-intl";

const SaleCard = ({ product }) => {
  const queryClient = getQueryClient();
  const {
    id,
    title,
    categ,
    onSale,
    preSale,
    sale,
    rating,
    aval,
    sold,
    img,
    quantity,
    price,
  } = product;
  const { addToCart } = useCart();
  const locale = useLocale();
  const { toast } = useToast();
  const [addedToWishList, setAddedToWishList] = useState(false);
  const toggleWishList = () => {
    setAddedToWishList(!addedToWishList);
    if (addedToWishList == true) {
      toast({
        description: "تمت الحذف من المفضله بنجاح",
        action: <FaCheckCircle size={20} className="text-green-500" />,
      });
    } else {
      toast({
        description: "تمت الاضافة إلى المفضله بنجاح",
        action: <FaCheckCircle size={20} className="text-green-500" />,
      });
    }
  };
  // function to add to cart
  async function addProductToCart() {
    addToCart({
      id,
      title,
      categ,
      onSale,
      preSale,
      sale,
      rating,
      aval,
      sold,
      img,
      quantity,
      price,
    });
    toast({
      description: "تمت الاضافة إلى السلة بنجاح",
      action: <FaCheckCircle size={20} className="text-green-500" />,
    });
    await queryClient.refetchQueries({
      queryKey: ["/cart/items", locale],
    });
  }

  return (
    <div className="block bg-white p-8 space-y-4 hover:shadow-md hover:scale-[1.02] transition-all duration-300">
      {/* rating and fav icon */}
      <div className="flex items-center justify-between">
        {/* rating */}
        <div className="flex items-center gap-1 ">
          <IoStar size={20} className="text-yellow-400" />
          <p className="font-semibold pt-1">{rating}</p>
        </div>
        {/* icon and rating */}
        <div className="flex items-center gap-2">
          <IoMdHeart
            size={22}
            onClick={toggleWishList}
            className={`${
              addedToWishList ? "text-red-500" : "text-[#F1CBCB]"
            } cursor-pointer`}
          />
          <span className="bg-[#38CB89] py-1 px-2 rounded text-xs text-white">
            {sale}%
          </span>
        </div>
      </div>
      {/* details */}
      <Link href={`/products/${id}`} className="block space-y-4">
        {/* image */}
        <div className="h-40 relative ">
          <FallbackImage
            src={img}
            fill
            alt={title}
            className="object-contain "
          />
        </div>
        {/* information */}
        <div className="text-center space-y-2">
          <h3 className="font-semibold text-xl">{title}</h3>
          <p className="text-sm text-gray-400 ">{categ}</p>
          <p className="text-xl font-bold space-x-2">
            <del className="text-sm text-gray-400">{preSale}</del>
            ج.م{onSale}{" "}
          </p>
        </div>
      </Link>
      {/* add to cart */}
      <button
        onClick={addProductToCart}
        className="btn btn-btnColor  flex items-center justify-center gap-2 py-3 w-full mx-auto"
      >
        <TbShoppingBagPlus size={20} className="text-yellow-400" />
        إضافة للسلة
      </button>
      {/* progress */}
      <div className="h-2 bg-[#F1EBEB]" dir="ltr">
        <div
          className={`h-full ${
            aval > sold ? "bg-green-500" : "bg-red-300"
          } w-3/4`}
        ></div>
      </div>
      {/* avil and sold */}
      <div className="flex items-center justify-between">
        <h4 className="text-xl font-extrabold">
          متاح:<span className="text-green-500">{aval}</span>
        </h4>
        <h4 className="text-xl font-extrabold">
          مباع:<span className="text-red-500">{sold}</span>
        </h4>
      </div>
    </div>
  );
};

export default SaleCard;
