"use client";
import SectionHeader from "../shared/SectionHeader";
import CountdownTimer from "./CountdownTimer";
import { LuChevronLeft, LuChevronRight } from "react-icons/lu";
import SaleCard from "./SaleCard";
import { useLocale } from "next-intl";
import { products } from "@/api/products";
import {
  Carousel,
  CarouselContent,
  CarouselItem,
  CarouselNext,
  CarouselPrevious,
} from "@/components/ui/carousel"
import { useState, useEffect } from 'react'
import clsx from "clsx";
import Autoplay from "embla-carousel-autoplay"
const SaleSlider = () => {
  const locale = useLocale();
  const [api, setApi] = useState();
  const [currentSlide, setCurrentSlide] = useState(0);
  const [totalSlides, setTotalSlides] = useState();
  useEffect(() => {
    if (!api) {
      return;
    }
    setTotalSlides(api.slideNodes().length);
    api.on("select", () => {
      setCurrentSlide(api.selectedScrollSnap())
    })
  }, [api])
  return (
    <div className="saleSlider">
      <div className="relative container">
        <SectionHeader title={"عروض "} marker={"اليوم"} withLink={false} />
        <CountdownTimer />
      </div>
      <div className="my-8 container">
        <Carousel
          className="w-full "
          setApi={setApi}
          dir="ltr"
          opts={{
            loop: true,
            startIndex: 3,
            align: "start",
          }}
          plugins={[
            Autoplay({
              delay: 3500,
            }),
          ]}
        >
          <CarouselContent className="" >
            {products?.map((product, index) => (
              <CarouselItem key={index} className="md:basis-1/2 lg:basis-1/3 ">
                <div className="lg:p-2 p-1">
                  <SaleCard product={product} />
                </div>
              </CarouselItem>
            ))}
          </CarouselContent>
          <div className="flex justify-center mt-4 gap-2 overflow-x-auto pb-2">
            {Array.from({ length: totalSlides }).map((_, index) => (
              <button
                key={index}
                className={clsx(`size-2 rounded-sm bg-gray-400 transition-all duration-300 flex-shrink-0`, {
                  'bg-main h-2 w-8': index === currentSlide,
                })}
                onClick={() => api?.scrollTo(index)}
              />
            ))}
          </div>
          <CarouselNext />
          <CarouselPrevious />
        </Carousel>
      </div>
    </div>
  );
};

export default SaleSlider;

// }