import Link from "next/link";
import React from "react";
import { FaArrowRight } from "react-icons/fa";

const SecondBanner = () => {
  const t = useTranslations('shared')
  return (
    <div className="container ">
      <div className="grid grid-cols-12 gap-6">
        <div className="col-span-12">
          <div className="p-8 bg-[url('/home/secondbanner1.png')] bg-no-repeat bg-cover lg:bg-center bg-right-top">
            <div className="text-center lg:text-start space-y-6">
              <Link
                href="#"
                className="border-b border-black flex items-center gap-2 font-bold w-fit p-4 hover:bg-black hover:text-white transition-all duration-300 mx-auto lg:mx-0"
              >
                <FaArrowRight size={16} />
                {t('shaping-now')}
              </Link>
            </div>
          </div>
        </div>
        <div className="md:col-span-6 col-span-12">
          <div className="lg:h-[40vh] p-12 bg-white lg:bg-[url('/home/secondbanner2.png')] bg-no-repeat bg-contain bg-right-top  flex items-center lg:justify-end justify-center">
            <div className="text-center lg:text-start space-y-4">
              <p className="lg:text-4xl text-2xl font-semibold ">
                سماعة<span className="font-extrabold ms-2">IPOD</span>
              </p>

              <p className="text-xl font-bold space-x-2">
                <del className="text-sm text-gray-400 me-2">1950.0</del>
                ج.م777{" "}
              </p>
              <Link
                href="#"
                className="border-b border-black flex items-center gap-2 font-bold w-fit p-4 hover:bg-black hover:text-white transition-all duration-300 mx-auto lg:mx-0"
              >
                <FaArrowRight size={16} />
                المزيد{" "}
              </Link>
            </div>
          </div>
        </div>
        <div className="md:col-span-6 col-span-12">
          <div className="lg:h-[40vh] p-12 bg-white lg:bg-[url('/home/secondbanner3.png')] bg-no-repeat bg-contain bg-right-top  flex items-center lg:justify-end justify-center">
            <div className="text-center lg:text-start space-y-4">
              <p className="lg:text-4xl text-2xl font-semibold ">
                كابل<span className="font-extrabold ms-2">TYPE C</span>
              </p>

              <p className="text-xl font-bold space-x-2">
                <del className="text-sm text-gray-400 me-2">1950.0</del>
                ج.م777{" "}
              </p>
              <Link
                href="#"
                className="border-b border-black flex items-center gap-2 font-bold w-fit p-4 hover:bg-black hover:text-white transition-all duration-300 mx-auto lg:mx-0"
              >
                <FaArrowRight size={16} />
                المزيد{" "}
              </Link>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default SecondBanner;
