import fetchData from "@/api/fetch-data"
import { getLocale } from "next-intl/server"
import Link from "next/link"
const Tabs = async () => {
  const locale = await getLocale()

  let tabs;
  const response = await fetchData({
    endPoint: "/categories",
    locale: locale
  })
  if (response.status == "success") {
    tabs = response.data
  }
  else {
    tabs = []
  }
  return (<>
    {tabs && tabs.length > 0 ?
      <div className="bg-white">
        <div className="container py-2 md:py-4 flex items-center gap-1 overflow-x-auto md:gap-2 md:flex-wrap ">
          {tabs?.map((tap, index) =>
            <Link href={`/products/filter/${tap.id}`} key={index} className="max-md:text-[11px] bg-light p-2 block hover:bg-main hover:text-white">
              {tap.title}
            </Link>

          )}
        </div>
      </div>
      :
      null
    }</>
  )
}

export default Tabs