"use client";
import { Button } from "@/components/ui/button";
import { BellRing, Loader2 } from "lucide-react";
import { useTranslations } from "next-intl";

export default function UpdateAuctionsPricesButton({
  refetch,
  isFetching,
  isLoading,
}) {
  const t = useTranslations();

  const handelOnClick = () => {
    refetch();
  };
  // Then in your button
  return (
    <Button
      onClick={handelOnClick}
      disabled={isLoading || isFetching}
      className="mx-2 flex gap-2"
    >
      {t("updateAuctions")}
      {isLoading || isFetching ? (
        <Loader2 className="animate-spin" />
      ) : (
        <BellRing />
      )}
    </Button>
  );
}
