import fetchData from "@/api/fetch-data";
import BrandSlider from "../BrandSlider";
import { getLocale } from "next-intl/server";

export default async function BrandsFetchData() {
  const locale = await getLocale();
  let brands;
  const response = await fetchData({ endPoint: "/brands", locale: locale });

  if (response?.status == "success") {
    brands = response?.data?.slice(0, 6);
  }
  return (
    <BrandSlider brands={brands} locale={locale} />
  );
}