"use client";
import { FaArrowRight } from "react-icons/fa";
import Link from "next/link";
import { useTranslations } from "next-intl";

export default function MainBanner({ data, displayTitle, published }) {
  const t = useTranslations('shared')

  return (
    // published == "1" ?
    //   <div className="bg-light h-60 "
    //     style={{
    //       backgroundImage: `url(${data.image})`,
    //       backgroundSize: "cover",
    //       backgroundPosition: "center"
    //     }}
    //   >
    //     <div className="h-full w-full bg-black/20 lg:p-8 p-4 flex flex-col lg:flex-row items-center justify-center lg:justify-between lg:gap-12 gap-2 ">
    //       <div className="space-y-2 lg:grow text-center lg:text-start ">
    //         <p className="font-bold text-2xl">
    //           {displayTitle == "1" ?
    //             data.title : data.banner_title || "title"
    //           }
    //         </p>
    //         <Link
    //           href={data.link || "#"}
    //           className="border-b border-black flex items-center gap-2 font-bold w-fit p-2 hover:bg-black hover:text-light transition-all duration-300 max-lg:mx-auto"
    //         >
    //           <FaArrowRight size={14} />
    //           {t('shaping-now')}
    //         </Link>
    //       </div>
    //     </div>
    //   </div> : null
    // REDESIGN THEME
    published == "1" ?
      <div className="bg-light  h-48 lg:h-72 2xl:h-80  rounded-lg overflow-hidden"
        style={{
          backgroundImage: `url(${data.image})`,
          backgroundSize: "cover",
          backgroundPosition: "center"
        }}
      >
        <div className="h-full w-full bg-black/20 lg:p-8 p-4 flex flex-col lg:flex-row items-center justify-center lg:justify-between lg:gap-12 gap-2 ">
          <div className="space-y-6 lg:grow text-center lg:text-start ">
            <p className="font-bold text-2xl lg:text-4xl text-white">
              {displayTitle == "1" ?
                data.title : data.banner_title || "title"
              }
            </p>
            <Link
              href={data.link || "#"}
              className=" flex items-center shadow-sm gap-2 rounded-md p-4 py-2 font-bold w-fit  bg-main text-white hover:bg-white hover:text-main transition-all duration-300 max-lg:mx-auto"
            >
              <FaArrowRight size={14} />
              {t('shaping-now')}
            </Link>
          </div>
        </div>
      </div> : null
  );
}