import fetchData from "@/api/fetch-data";
import { getLocale } from "next-intl/server";

import ProductCard from "../../shared/ProductCard";
import SectionHeader from "../../shared/SectionHeader";

export default async function MainSection({ sectionType, title, displayTitle, published }) {
  const locale = await getLocale()
  let productsData = [];
  // handled title and marker
  const words = title?.trim().split(" ");
  const lastWord = words?.pop();
  const restOfTitle = words?.join(" ");
  if (published == "1") {
    const response = await fetchData({ endPoint: `/sections/${sectionType}`, locale: locale });
    if (response.status == "success") {
      productsData = response.data[0].products;
    }
  }
  if (productsData.length > 0) {
    return (
      published == "1" ?
        <div>
          {displayTitle == "1" ?
            <SectionHeader title={restOfTitle} marker={lastWord} withLink={false} link={"/products/310"} />
            : null
          }
          <div className="grid grid-cols-12 gap-2 md:gap-4 xl:gap-6 my-6">
            {productsData.map((item) => (
              <div key={item.id} className="col-span-12 lg:col-span-6 2xl:col-span-4">
                <ProductCard product={item} />
              </div>
            ))}
          </div>
        </div> : null
    );
  }
  return (null)
}



