import fetchData from "@/api/fetch-data";
import { Separator } from "@/components/ui/separator";
import ProductCard from "../../shared/ProductCard";
import SectionHeader from "../../shared/SectionHeader";

export default async function SideSection({ sectionType, title, displayTitle, published }) {
  let productsData;

  // handled title and marker
  const words = title.trim().split(" ");
  const lastWord = words.pop();
  const restOfTitle = words.join(" ");
  // handled banner or products layout
  if (published == "1") {
    const response = await fetchData({ endPoint: `/sections/${sectionType}` });
    if (response.status == "success") {
      productsData = response.data[0].products;
    }
  }
  return (
    published == "1" ?
      <div>
        {displayTitle == "1" ?
          <SectionHeader title={restOfTitle} marker={lastWord} withLink={false} />
          : null
        }
        {productsData?.map((item, index) => (
          <>
            <div key={index} className="my-4">
              <ProductCard product={item} h={true} />
            </div>
            {index == productsData?.length - 1 ? <div></div> :
              <Separator className="col-span-12 mt-4" />
            }
          </>
        ))}
      </div> : null
  );
}
