import fetchData from "@/api/fetch-data";
import ProductCard from "../../shared/ProductCard";
import SectionHeader from "../../shared/SectionHeader";

export default async function SideSectionRedesignThree({
  sectionType,
  title,
  displayTitle,
  published,
}) {
  let productsData;

  // handled title and marker
  const words = title.trim().split(" ");
  const lastWord = words.pop();
  const restOfTitle = words.join(" ");
  // handled banner or products layout
  if (published == "1") {
    const response = await fetchData({ endPoint: `/sections/${sectionType}` });
    if (response.status == "success") {
      productsData = response.data[0].products;
    }
  }
  return published == "1" ? (
    <>
      <>
        {displayTitle == "1" ? (
          <SectionHeader title={restOfTitle} marker={lastWord} withLink={false} />
        ) : null}
      </>
      <div className="grid max-md:grid-cols-1 md:grid-cols-2 lg:grid-cols-1 gap-4">
        {productsData?.map((item, index) => (
          <>
            <div key={index} className="my-4">
              <ProductCard product={item} h={true} />
            </div>
          </>
        ))}
      </div>
    </>
  ) : null;
}
