import {
  Sheet,
  SheetContent,
  SheetDescription,
  SheetHeader,
  SheetTitle,
  SheetTrigger,
} from "@/components/ui/sheet";
import { useTranslations } from "next-intl";
import SectionHeader from "../shared/SectionHeader";
import Filter from "./Filter";
export default function FilterSheet({ filters }) {
  const t = useTranslations("filter");
  return (
    <div>
      <Sheet>
        <SheetTrigger className="btn btn-main rounded-md w-full">
          {t("specifyyourproduct")}
        </SheetTrigger>
        <SheetContent side={"left"} className="overflow-auto">
          <SheetHeader>
            <SheetTitle>
              <SectionHeader
                title={t("filter")}
                marker={t("search")}
                withLink={false}
              />
            </SheetTitle>
            <SheetDescription className="space-y-6 pt-6 ">
              <Filter filters={filters} />
            </SheetDescription>
          </SheetHeader>
        </SheetContent>
      </Sheet>
    </div>
  );
}
