"use client";

import { useState } from "react";
import Filter from "./Filter";
import ProductsLayout from "./ProductsLayout";

export default function ProductLayoutClient({ data, subCategories }) {
  const [isFilteredLoading, setIsFilteredLoading] = useState(false);

  return (
    <div className="grid grid-cols-12 gap-6">
      {/* filter */}
      <div className="lg:col-span-2 md:col-span-4 hidden md:block">
        <Filter
          filters={data?.filters}
          subCategories={subCategories}
          isFilteredLoading={isFilteredLoading}
          setIsFilteredLoading={setIsFilteredLoading}
        />
      </div>
      {/* product preview */}
      <div className="lg:col-span-10 md:col-span-8 col-span-12">
        <ProductsLayout
          data={data}
          isFilteredLoading={isFilteredLoading}
          setIsFilteredLoading={setIsFilteredLoading}
        />
      </div>
    </div>
  );
}
