import { buttonVariants } from "@/components/ui/button";
import { cn } from "@/lib/utils";
import { getTranslations } from "next-intl/server";
import Link from "next/link";
import React from "react";

export default async function SubCategories({ subCategories }) {
  const t = await getTranslations();
  return (
    <div>
      <h2 className="font-bold text-2xl text-main">{t("subCategories")}</h2>
      <div className="flex flex-wrap gap-2 my-3">
        {subCategories.map((category) => (
          <Link
            key={category.id}
            href={`/products/filter/${category.id}`}
            className={cn(
              buttonVariants({ variant: "default" }),
              "rounded-full cursor-pointer"
            )}
          >
            {category.title}
          </Link>
        ))}
      </div>
    </div>
  );
}
