import { CiDeliveryTruck } from "react-icons/ci";
import { FaXTwitter } from "react-icons/fa6";
import { PiEnvelopeSimple, PiPhoneLight, PiYoutubeLogoLight } from "react-icons/pi";
import { SlSocialFacebook, SlSocialInstagram } from "react-icons/sl";
import { TbCashBanknote } from "react-icons/tb";
import { TfiLock } from "react-icons/tfi";

import { Separator } from "@/components/ui/separator";
import { siteSettingFallback } from "@/lib/utils";
import { getTranslations } from "next-intl/server";
import Link from "next/link";
import { BsSnapchat } from "react-icons/bs";
import FallbackImage from "../../FallbackImage";
import NewsLetterOne from "./NewsLetterone";
import BrandSectionRedesign from "../../BrandSectionRedesign/BrandSectionRedesign";
const FooterRedesign = async ({ siteSetting }) => {
    const data = siteSetting?.site_settings || siteSettingFallback?.site_settings;
    const dataFallBack = siteSettingFallback?.site_settings;
    const f = await getTranslations("footer");

    return (
        <footer className=" bg-white  ">


            {/* advanteges */}
            <div className="container ">
                <div className="grid grid-cols-12 gap-6 items-center py-5">
                    <div className="lg:col-span-4 md:col-span-6 col-span-12">
                        <div className="rounded-lg py-6 px-12 flex items-center gap-2">
                            <CiDeliveryTruck size={55} className="text-main" />
                            <div>
                                <h4 className="font-bold">{f("freeDelivery")} </h4>
                                <p className="text-sm text-gray-500">
                                    {f("freeDeliveryDescription")}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div className="lg:col-span-4 md:col-span-6 col-span-12">
                        <div className="rounded-lg py-6 px-12 flex items-center gap-2">
                            <TbCashBanknote size={55} className="text-main" />
                            <div>
                                <h4 className="font-bold">{f("cashback")}</h4>
                                <p className="text-sm text-gray-500">
                                    {f("cashbackDescription")}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div className="lg:col-span-4 md:col-span-6 col-span-12">
                        <div className="rounded-lg py-6 px-12 flex items-center gap-2">
                            <TfiLock size={55} className="text-main" />
                            <div>
                                <h4 className="font-bold">{f("securePayment")}</h4>
                                <p className="text-sm text-gray-500">
                                    {f("securePaymentDescription")}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div className="h-[.5px] w-full container bg-slate-200 "></div>
                <div className="text-black bg-white space-y-6">
                    {/* links */}
                    <div className="container py-10">
                        <div className="grid grid-cols-12 gap-6">
                            {/* logo */}
                            <div className="lg:col-span-3 md:col-span-6 col-span-12 space-y-6">
                                {/* logo */}
                                <div className="relative pb-4   w-fit mx-auto md:mx-0">
                                    <FallbackImage
                                        src={
                                            siteSetting?.images?.footer ||
                                            siteSettingFallback?.images?.footer
                                        }
                                        alt="footer logo"
                                        width={70}
                                        height={70}
                                    />
                                </div>
                                {/* location */}
                                <div className="space-y-4 ">
                                    <p className="flex items-center gap-2 justify-center md:justify-start">
                                        <PiPhoneLight size={24} className="font-bold" />
                                        <a
                                            href={`https://wa.me/${data?.phone1}`}
                                            target="_blank"
                                            rel="noopener noreferrer"
                                        >
                                            {data?.phone1}
                                        </a>
                                        -
                                        <a
                                            href={`https://wa.me/${data?.phone2}`}
                                            target="_blank"
                                            rel="noopener noreferrer"
                                        >
                                            {data?.phone2}
                                        </a>
                                    </p>
                                    <a
                                        href={`mailto:${data?.mail_url}`}
                                        target="_blank"
                                        className="flex items-center gap-2 justify-center md:justify-start"
                                    >
                                        <PiEnvelopeSimple size={24} className="font-bold" />
                                        {data?.mail_url}
                                    </a>
                                </div>
                                {/* social */}
                                {data?.show_social_icons == 1 ? (
                                    <div className="flex items-center gap-4 justify-center md:justify-start">
                                        <Link
                                            href={data?.facebook_url}
                                            className=" hover:text-main transition-all duration-300"
                                        >
                                            <SlSocialFacebook size={24} />
                                        </Link>
                                        <Link
                                            href={data?.instagram_url}
                                            className=" hover:text-main transition-all duration-300"
                                        >
                                            <SlSocialInstagram size={24} />
                                        </Link>
                                        <Link
                                            href={data?.twitter_url}
                                            className=" hover:text-main transition-all duration-300"
                                        >
                                            <FaXTwitter size={24} />
                                        </Link>
                                        <Link
                                            href={data?.snapchat_url}
                                            className=" hover:text-main transition-all duration-300"
                                        >
                                            <BsSnapchat size={24} />
                                        </Link>
                                        <Link
                                            href={data?.youtube_url}
                                            className=" hover:text-main transition-all duration-300"
                                        >
                                            <PiYoutubeLogoLight size={24} />
                                        </Link>
                                    </div>
                                ) : (
                                    ""
                                )}
                            </div>
                            {/* links */}
                            <div className="lg:col-span-3 col-span-6 space-y-6">
                                <h3 className="text-xl font-bold relative pb-4 ">
                                    {f("importantLinks")}
                                </h3>
                                <ul className="space-y-4">
                                    <li>
                                        <Link href="/" className="hover:text-main">
                                            {f("home")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/about-us" className="hover:text-main">
                                            {f("aboutUs")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/offers" className="hover:text-main">
                                            {f("offers")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/articles" className="hover:text-main">
                                            {f("articles")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/contact" className="hover:text-main">
                                            {f("contact")}
                                        </Link>
                                    </li>
                                </ul>
                            </div>
                            {/* links */}
                            <div className="lg:col-span-3 col-span-6 space-y-6">
                                <h3 className="text-xl font-bold relative pb-4 ">
                                    {f("otherlinks")}
                                </h3>
                                <ul className="space-y-4">
                                    <li>
                                        <Link href="/sign-in" className="hover:text-main">
                                            {f("sign-in")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/sign-up" className="hover:text-main">
                                            {f("sign-up")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/brands" className="hover:text-main">
                                            {f("brands")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/categories" className="hover:text-main">
                                            {f("categories")}
                                        </Link>
                                    </li>
                                    <li>

                                        {/* roles */}
                                        <Link
                                            href={"/terms-and-conditions"}
                                            className="lg:flex items-center gap-2 text-sm hidden hover:text-main transition-all duration-300"
                                        >
                                            <span>{f("termsAndConditions")}</span>
                                            <Separator orientation="vertical" className="h-6" />
                                            <span>{f("privacyPolicy")}</span>
                                        </Link>
                                    </li>
                                </ul>
                            </div>
                            {/* app */}
                            <div className="lg:col-span-3 col-span-6 space-y-6">
                                <h3 className="text-xl font-bold relative pb-4 ">
                                    {f("downloadApp")}
                                </h3>
                                <div>
                                    <Link href="#" className="block">
                                        <FallbackImage
                                            src="/footer/apple.png"
                                            alt="ios-logo"
                                            className="hover:scale-105 transition-all duration-300 rounded-2xl"
                                            width={200}
                                            height={50}
                                        />
                                    </Link>
                                </div>
                                <div>
                                    <Link href="#" className=" transition-all duration-300 block">
                                        <FallbackImage
                                            src="/footer/andriod.png"
                                            alt="android-logo"
                                            width={200}
                                            className="hover:scale-105 transition-all duration-300 rounded-2xl"
                                            height={50}
                                        />
                                    </Link>
                                </div>
                            </div>

                        </div>
                    </div>
                    {/* copyrights */}

                    {data?.show_payment_gates == 1 ? (
                        <div className="container  border-t py-4 flex items-center md:justify-between justify-center flex-col md:flex-row gap-2">
                            {/* payment */}
                            <FallbackImage
                                src="/footer/payment.png"
                                alt="payment"
                                width={300}
                                className="filter grayscale hover:grayscale-0 transition-all duration-300"
                                height={30}
                            />

                            {/* copy rights */}
                            <p className="text-sm">
                                {f("copyright1")} &copy; {new Date().getFullYear()}{" "}
                                . {f("copyright2")}{" "}
                                <span className="font-bold text-main">
                                    <Link href={"https://serv5.com"} target="_blank">
                                        Serv5
                                    </Link>
                                </span>
                            </p>
                        </div>
                    ) : (
                        ""
                    )}
                </div>
            </div>
        </footer>
    );
};

export default FooterRedesign;
