import { CiDeliveryTruck } from "react-icons/ci";
import { FaXTwitter } from "react-icons/fa6";
import {
  PiEnvelopeSimple,
  PiPhoneLight,
  PiYoutubeLogoLight,
} from "react-icons/pi";
import { SlSocialFacebook, SlSocialInstagram } from "react-icons/sl";
import { TfiLock } from "react-icons/tfi";

import { siteSettingFallback } from "@/lib/utils";
import { getTranslations } from "next-intl/server";
import Link from "next/link";
import { BsSnapchat } from "react-icons/bs";
import FallbackImage from "../../FallbackImage";
import NewsLetterOne from "./NewsLetterone";
import { CircleDollarSign, Lock } from "lucide-react";
const FooterRedesignThree = async ({ siteSetting }) => {
  const data = siteSetting?.site_settings || siteSettingFallback?.site_settings;
  const f = await getTranslations("footer");

  return (
    <footer className=" bg-mainDark text-gray-400  ">
      {/* advanteges */}
      <div className="container ">
        <div className="grid grid-cols-12 gap-4 items-center py-2">
          <div className="lg:col-span-4 md:col-span-6 col-span-12">
            <div className="rounded-lg py-4 px-12 flex items-center gap-2">
              <CiDeliveryTruck size={44} className="text-secondary" />
              <div>
                <h4 className=" text-white font-bold">{f("freeDelivery")} </h4>
              </div>
            </div>
          </div>

          <div className="lg:col-span-4 md:col-span-6 col-span-12">
            <div className="rounded-lg py-6 px-12 flex items-center gap-2">
              <CircleDollarSign size={44} className="text-secondary" />
              <div>
                <h4 className=" text-white font-bold">{f("securePayment")}</h4>
                <p className="text-sm text-light">
                  {f("securePaymentDescription")}
                </p>
              </div>
            </div>
          </div>

          <div className="lg:col-span-4 md:col-span-6 col-span-12">
            <div className="rounded-lg py-6 px-12 flex items-center gap-2">
              <Lock size={44} className="text-secondary" />
              <div>
                <h4 className=" text-white font-bold">{f("trust")}</h4>
                <p className="text-sm text-light">{f("unLimitedTrust")}</p>
              </div>
            </div>
          </div>
        </div>

        <div className="h-[.5px] w-full container bg-light "></div>
        <div className="space-y-3">
          {/* links */}
          <div className="container py-10">
            <div className="grid grid-cols-12 gap-6">
              {/* logo */}
              <div className="lg:col-span-4 md:col-span-6 col-span-12 space-y-3">
                {/* logo */}
                <div className="relative pb-4   w-fit mx-auto md:mx-0">
                  <Link href="/">
                    <FallbackImage
                      src={siteSetting?.images?.header}
                      alt="logo"
                      width={200}
                      height={80}
                      className="w-[200px] h-[80px]"
                    />
                  </Link>
                </div>
                {/* location */}
                <div className="space-y-4 ">
                  <p className="flex items-center gap-2 justify-center md:justify-start">
                    <PiPhoneLight size={24} className="font-bold" />
                    <a
                      href={`https://wa.me/${data?.phone1}`}
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      {data?.phone1}
                    </a>
                    -
                    <a
                      href={`https://wa.me/${data?.phone2}`}
                      target="_blank"
                      rel="noopener noreferrer"
                    >
                      {data?.phone2}
                    </a>
                  </p>
                  <a
                    href={`mailto:${data?.mail_url}`}
                    target="_blank"
                    className="flex items-center gap-2 justify-center md:justify-start"
                  >
                    <PiEnvelopeSimple size={24} className="font-bold" />
                    {data?.mail_url}
                  </a>
                </div>
                <div className="flex  items-center gap-4 justify-center md:justify-start">
                  <Link href="#" className="block">
                    <FallbackImage
                      src="/footer/applethree.png"
                      alt="ios-logo"
                      className="rounded-md w-32"
                      width={550}
                      height={550}
                    />
                  </Link>
                  <Link href="#" className=" transition-all duration-300 block">
                    <FallbackImage
                      src="/footer/androidthree.png"
                      alt="android-logo"
                      width={550}
                      className="rounded-md w-32"
                      height={550}
                    />
                  </Link>
                </div>
                {/* social */}
                {data?.show_social_icons == 1 ? (
                  <div className="flex items-center text-white gap-4 justify-center md:justify-start">
                    <Link
                      href={data?.facebook_url}
                      className="text-light   p-2 rounded-full border-light hover:border-secondary hover:text-dark  border-[1px] hover:bg-secondary transition-all duration-100"
                    >
                      <SlSocialFacebook size={18} />
                    </Link>
                    <Link
                      href={data?.instagram_url}
                      className="text-light   p-2 rounded-full border-light hover:border-secondary hover:text-dark  border-[1px] hover:bg-secondary transition-all duration-100"
                    >
                      <SlSocialInstagram size={18} />
                    </Link>
                    <Link
                      href={data?.twitter_url}
                      className="text-light  p-2 rounded-full border-light hover:border-secondary hover:text-dark  border-[1px] hover:bg-secondary transition-all duration-100"
                    >
                      <FaXTwitter size={18} />
                    </Link>
                    <Link
                      href={data?.snapchat_url}
                      className="text-light   p-2 rounded-full border-light hover:border-secondary hover:text-dark  border-[1px] hover:bg-secondary transition-all duration-100"
                    >
                      <BsSnapchat size={18} />
                    </Link>
                    <Link
                      href={data?.youtube_url}
                      className="text-light   p-2 rounded-full border-light hover:border-secondary hover:text-dark  border-[1px] hover:bg-secondary transition-all duration-100"
                    >
                      <PiYoutubeLogoLight size={18} />
                    </Link>
                  </div>
                ) : (
                  ""
                )}
              </div>
              {/* links */}
              <div className="lg:col-span-2 col-span-6 space-y-3">
                <h3 className="text-xl text-white font-bold relative pb-4 ">
                  {f("importantLinks")}
                </h3>
                <ul className="space-y-4">
                  <li>
                    <Link href="/" className="hover:text-secondary">
                      {f("home")}
                    </Link>
                  </li>
                  <li>
                    <Link href="/about-us" className="hover:text-secondary">
                      {f("aboutUs")}
                    </Link>
                  </li>
                  <li>
                    <Link href="/offers" className="hover:text-secondary">
                      {f("offers")}
                    </Link>
                  </li>
                  <li>
                    <Link href="/articles" className="hover:text-secondary">
                      {f("articles")}
                    </Link>
                  </li>
                  <li>
                    <Link href="/contact" className="hover:text-secondary">
                      {f("contact")}
                    </Link>
                  </li>
                  <li>
                    <Link
                      href={"/exchange-return"}
                      className=" hover:text-secondary"
                    >
                      {f("exchangeReturn")}
                    </Link>
                  </li>
                </ul>
              </div>
              {/* links */}
              <div className="lg:col-span-2 col-span-6 space-y-3">
                <h3 className="text-xl font-bold text-white relative pb-4 ">
                  {f("otherlinks")}
                </h3>
                <ul className="space-y-4">
                  <li>
                    <Link href="/sign-in" className="hover:text-secondary">
                      {f("sign-in")}
                    </Link>
                  </li>
                  <li>
                    <Link href="/sign-up" className="hover:text-secondary">
                      {f("sign-up")}
                    </Link>
                  </li>
                  <li>
                    <Link href="/brands" className="hover:text-secondary">
                      {f("brands")}
                    </Link>
                  </li>
                  <li>
                    <Link href="/categories" className="hover:text-secondary">
                      {f("categories")}
                    </Link>
                  </li>
                  <li>
                    <Link
                      href={"/terms-and-conditions"}
                      className=" hover:text-secondary"
                    >
                      {f("termsAndConditions")}
                    </Link>
                  </li>
                </ul>
              </div>
              {/* input */}
              <div className="lg:col-span-4 md:col-span-6 col-span-12 space-y-3">
                <h3 className="text-xl text-white font-bold relative pb-4 w-fit mx-auto md:mx-0">
                  {f("newsletter")}
                </h3>
                <p className="text-center md:text-start">
                  {f("newsletterSignup")}
                </p>
                <NewsLetterOne />
              </div>
            </div>
          </div>
          {/* copyrights */}

          {data?.show_payment_gates == 1 ? (
            <div className="container border-t text-center border-light flex flex-col md:flex-row items-center justify-between gap-4 py-8">
              {/* payment */}
              <FallbackImage
                src="/footer/payment.png"
                alt="payment"
                width={300}
                className=""
                height={30}
              />
              {/* copy rights */}
              <p className="text-sm">
                {f("copyright1")} &copy; {new Date().getFullYear()} .{" "}
                {f("copyright2")}{" "}
                <span className="font-bold text-secondary">
                  <Link href={"https://serv5.com"} target="_blank">
                    Serv5
                  </Link>
                </span>
              </p>
            </div>
          ) : (
            ""
          )}
        </div>
      </div>
    </footer>
  );
};

export default FooterRedesignThree;
