import { CiDeliveryTruck } from "react-icons/ci";
import { FaXTwitter } from "react-icons/fa6";
import { PiEnvelopeSimple, PiPhoneLight, PiYoutubeLogoLight } from "react-icons/pi";
import { SlSocialFacebook, SlSocialInstagram } from "react-icons/sl";
import { TbCashBanknote } from "react-icons/tb";
import { TfiLock } from "react-icons/tfi";

import { Separator } from "@/components/ui/separator";
import { siteSettingFallback } from "@/lib/utils";
import { getTranslations } from "next-intl/server";
import Link from "next/link";
import { BsSnapchat } from "react-icons/bs";
import FallbackImage from "../../FallbackImage";
import NewsLetterOne from "./NewsLetterone";
const FooterRedesignTwo = async ({ siteSetting }) => {
    const data = siteSetting?.site_settings || siteSettingFallback?.site_settings;
    const dataFallBack = siteSettingFallback?.site_settings;
    const f = await getTranslations("footer");

    return (
        <footer className=" bg-mainDark text-[#6b6b6c]  ">
            {/* advanteges */}
            <div className="container ">
                <div className="grid grid-cols-12 gap-4 items-center py-2">
                    <div className="lg:col-span-4 md:col-span-6 col-span-12">
                        <div className="rounded-lg py-4 px-12 flex items-center gap-2">
                            <CiDeliveryTruck size={44} className="text-secondary" />
                            <div>
                                <h4 className=" text-white font-bold">{f("freeDelivery")} </h4>
                                <p className="text-sm text-gray-500">
                                    {f("freeDeliveryDescription")}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div className="lg:col-span-4 md:col-span-6 col-span-12">
                        <div className="rounded-lg py-6 px-12 flex items-center gap-2">
                            <TbCashBanknote size={44} className="text-secondary" />
                            <div>
                                <h4 className=" text-white font-bold">{f("cashback")}</h4>
                                <p className="text-sm text-gray-500">
                                    {f("cashbackDescription")}
                                </p>
                            </div>
                        </div>
                    </div>
                    <div className="lg:col-span-4 md:col-span-6 col-span-12">
                        <div className="rounded-lg py-6 px-12 flex items-center gap-2">
                            <TfiLock size={44} className="text-secondary" />
                            <div>
                                <h4 className=" text-white font-bold">{f("securePayment")}</h4>
                                <p className="text-sm text-gray-500">
                                    {f("securePaymentDescription")}
                                </p>
                            </div>
                        </div>
                    </div>

                </div>

                <div className="h-[.5px] w-full container bg-[#6b6b6c] "></div>
                <div className="space-y-3">
                    {/* links */}
                    <div className="container py-10">
                        <div className="grid grid-cols-12 gap-6">
                            {/* logo */}
                            <div className="lg:col-span-4 md:col-span-6 col-span-12 space-y-3">
                                {/* logo */}
                                <div className="relative pb-4   w-fit mx-auto md:mx-0">
                                    <FallbackImage
                                        src={
                                            siteSetting?.images?.footer ||
                                            siteSettingFallback?.images?.footer
                                        }
                                        alt="footer logo"
                                        width={70}
                                        height={70}
                                    />
                                </div>
                                {/* location */}
                                <div className="space-y-4 ">
                                    <p className="flex items-center gap-2 justify-center md:justify-start">
                                        <PiPhoneLight size={24} className="font-bold" />
                                        <a
                                            href={`https://wa.me/${data?.phone1}`}
                                            target="_blank"
                                            rel="noopener noreferrer"
                                        >
                                            {data?.phone1}
                                        </a>
                                        -
                                        <a
                                            href={`https://wa.me/${data?.phone2}`}
                                            target="_blank"
                                            rel="noopener noreferrer"
                                        >
                                            {data?.phone2}
                                        </a>
                                    </p>
                                    <a
                                        href={`mailto:${data?.mail_url}`}
                                        target="_blank"
                                        className="flex items-center gap-2 justify-center md:justify-start"
                                    >
                                        <PiEnvelopeSimple size={24} className="font-bold" />
                                        {data?.mail_url}
                                    </a>
                                </div>
                                <div className="flex items-center gap-4 justify-center md:justify-start">
                                    <Link href="#" className="block">
                                        <FallbackImage
                                            src="/footer/apple.png"
                                            alt="ios-logo"
                                            className="rounded-md"
                                            width={170}
                                            height={50}
                                        />
                                    </Link>
                                    <Link href="#" className=" transition-all duration-300 block">
                                        <FallbackImage
                                            src="/footer/andriod.png"
                                            alt="android-logo"
                                            width={170}
                                            className="rounded-md"
                                            height={50}
                                        />
                                    </Link>
                                </div>
                                {/* social */}
                                {data?.show_social_icons == 1 ? (
                                    <div className="flex items-center text-white gap-4 justify-center md:justify-start">
                                        <Link
                                            href={data?.facebook_url}
                                            className="hover:text-black bg-[#1877F2] p-2 rounded-md transition-all duration-300"
                                        >
                                            <SlSocialFacebook size={24} />
                                        </Link>
                                        <Link
                                            href={data?.instagram_url}
                                            className="hover:text-black bg-gradient-to-r from-pink-500 via-purple-500 to-orange-500 p-2 rounded-md transition-all duration-300"
                                        >
                                            <SlSocialInstagram size={24} />
                                        </Link>
                                        <Link
                                            href={data?.twitter_url}
                                            className="hover:text-black bg-[#1DA1F2] p-2 rounded-md transition-all duration-300"
                                        >
                                            <FaXTwitter size={24} />
                                        </Link>
                                        <Link
                                            href={data?.snapchat_url}
                                            className="hover:text-black text-black bg-[#FFFC00] p-2 rounded-md transition-all duration-300"
                                        >
                                            <BsSnapchat size={24} />
                                        </Link>
                                        <Link
                                            href={data?.youtube_url}
                                            className="hover:text-black bg-[#FF0000] p-2 rounded-md transition-all duration-300"
                                        >
                                            <PiYoutubeLogoLight size={24} />
                                        </Link>
                                    </div>
                                ) : (
                                    ""
                                )}
                            </div>
                            {/* links */}
                            <div className="lg:col-span-2 col-span-6 space-y-3">
                                <h3 className="text-xl text-white font-bold relative pb-4 ">
                                    {f("importantLinks")}
                                </h3>
                                <ul className="space-y-4">
                                    <li>
                                        <Link href="/" className="hover:text-secondary">
                                            {f("home")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/about-us" className="hover:text-secondary">
                                            {f("aboutUs")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/offers" className="hover:text-secondary">
                                            {f("offers")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/articles" className="hover:text-secondary">
                                            {f("articles")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/contact" className="hover:text-secondary">
                                            {f("contact")}
                                        </Link>
                                    </li>
                                </ul>
                            </div>
                            {/* links */}
                            <div className="lg:col-span-2 col-span-6 space-y-3">
                                <h3 className="text-xl font-bold text-white relative pb-4 ">
                                    {f("otherlinks")}
                                </h3>
                                <ul className="space-y-4">
                                    <li>
                                        <Link href="/sign-in" className="hover:text-secondary">
                                            {f("sign-in")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/sign-up" className="hover:text-secondary">
                                            {f("sign-up")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/brands" className="hover:text-secondary">
                                            {f("brands")}
                                        </Link>
                                    </li>
                                    <li>
                                        <Link href="/categories" className="hover:text-secondary">
                                            {f("categories")}
                                        </Link>
                                    </li>
                                    <li>

                                        {/* roles */}
                                        <Link
                                            href={"/terms-and-conditions"}
                                            className="lg:flex items-center gap-2 text-sm hidden hover:text-secondary transition-all duration-300"
                                        >
                                            <span>{f("termsAndConditions")}</span>
                                            <Separator orientation="vertical" className="h-6 bg-[#6b6b6c]" />
                                            <span>{f("privacyPolicy")}</span>
                                        </Link>
                                    </li>
                                </ul>
                            </div>

                            {/* input */}
                            <div className="lg:col-span-4 md:col-span-6 col-span-12 space-y-3">
                                <h3 className="text-xl text-white font-bold relative pb-4 w-fit mx-auto md:mx-0">
                                    {f("newsletter")}
                                </h3>
                                <p className="text-center md:text-start">
                                    {f("newsletterSignup")}
                                </p>
                                <NewsLetterOne />
                            </div>
                        </div>
                    </div>
                    {/* copyrights */}

                    {data?.show_payment_gates == 1 ? (
                        <div className="container  border-t border-[#6b6b6c] py-4 lg:py-10 flex items-center md:justify-between justify-center flex-col  gap-2">
                            {/* copy rights */}
                            <p className="text-sm">
                                {f("copyright1")} &copy; {new Date().getFullYear()}{" "}
                                . {f("copyright2")}{" "}
                                <span className="font-bold text-secondary">
                                    <Link href={"https://serv5.com"} target="_blank">
                                        Serv5
                                    </Link>
                                </span>
                            </p>
                            {/* payment */}
                            <FallbackImage
                                src="/footer/payment.png"
                                alt="payment"
                                width={300}
                                className=""
                                height={30}
                            />

                        </div>
                    ) : (
                        ""
                    )}
                </div>
            </div>
        </footer >
    );
};

export default FooterRedesignTwo;
