import { CiDeliveryTruck } from "react-icons/ci";
import { FaInstagram, FaSnapchatGhost } from "react-icons/fa";
import { FaFacebookF, FaXTwitter, FaYoutube } from "react-icons/fa6";
import { PiEnvelopeSimple, PiPhoneLight } from "react-icons/pi";
import { TbCashBanknote } from "react-icons/tb";
import { TfiLock } from "react-icons/tfi";

import fetchData from "@/api/fetch-data";
import { Separator } from "@/components/ui/separator";
import { getLocale, getTranslations } from "next-intl/server";
import Link from "next/link";
import FallbackImage from "../../FallbackImage";
import NewsLetterOne from "./NewsLetterone";
import { siteSettingFallback } from "@/lib/utils";
const Footerone = async ({ siteSetting }) => {
  const data = siteSetting?.site_settings || siteSettingFallback?.site_settings;
  const dataFallBack = siteSettingFallback?.site_settings;
  const f = await getTranslations("footer");

  return (
    <footer className="space-y-6 ">
      {/* advanteges */}
      <div className="container">
        <div className="grid grid-cols-12 gap-6">
          <div className="lg:col-span-4 md:col-span-6 col-span-12">
            <div className="bg-white shadow-md rounded-lg py-6 px-12 flex items-center gap-2">
              <CiDeliveryTruck size={32} />
              <div>
                <h4 className=" text-main font-bold">{f("freeDelivery")} </h4>
                <p className="text-sm text-gray-500">
                  {f("freeDeliveryDescription")}
                </p>
              </div>
            </div>
          </div>
          <div className="lg:col-span-4 md:col-span-6 col-span-12">
            <div className="bg-white shadow-md rounded-lg py-6 px-12 flex items-center gap-2">
              <TbCashBanknote size={32} />
              <div>
                <h4 className=" text-main font-bold">{f("cashback")}</h4>
                <p className="text-sm text-gray-500">
                  {f("cashbackDescription")}
                </p>
              </div>
            </div>
          </div>
          <div className="lg:col-span-4 md:col-span-6 col-span-12">
            <div className="bg-white shadow-md rounded-lg py-6 px-12 flex items-center gap-2">
              <TfiLock size={32} />
              <div>
                <h4 className=" text-main font-bold">{f("securePayment")}</h4>
                <p className="text-sm text-gray-500">
                  {f("securePaymentDescription")}
                </p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className="bg-gradient-to-r from-mainDark to-mainDark text-gray-500 space-y-6">
        {/* links */}
        <div className="container py-10">
          <div className="grid grid-cols-12 gap-6">
            {/* logo */}
            <div className="lg:col-span-3 md:col-span-6 col-span-12 space-y-6">
              {/* logo */}
              <div className="relative pb-4  before:h-[1px] before:w-12 before:bg-gray-500 before:absolute before:bottom-0 before:start-0 w-fit mx-auto md:mx-0">
                <FallbackImage
                  src={
                    siteSetting?.images?.footer ||
                    siteSettingFallback?.images?.footer
                  }
                  alt="footer logo"
                  width={70}
                  height={70}
                />
              </div>
              {/* location */}
              <div className="space-y-4 ">
                <p className="flex items-center gap-2 justify-center md:justify-start">
                  <PiPhoneLight size={24} className="font-bold" />
                  <a
                    href={`https://wa.me/${data?.phone1}`}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    {data?.phone1}
                  </a>
                  -
                  <a
                    href={`https://wa.me/${data?.phone2}`}
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    {data?.phone2}
                  </a>
                </p>
                <a
                  href={`mailto:${data?.mail_url}`}
                  target="_blank"
                  className="flex items-center gap-2 justify-center md:justify-start"
                >
                  <PiEnvelopeSimple size={24} className="font-bold" />
                  {data?.mail_url}
                </a>
              </div>
              {/* social */}
              {data?.show_social_icons == 1 ? (
                <div className="flex items-center gap-4 justify-center md:justify-start">
                  <Link
                    href={data?.facebook_url}
                    className=" hover:text-main transition-all duration-300"
                  >
                    <FaFacebookF size={24} />
                  </Link>
                  <Link
                    href={data?.youtube_url}
                    className=" hover:text-main transition-all duration-300"
                  >
                    <FaYoutube size={24} />
                  </Link>
                  <Link
                    href={data?.instagram_url}
                    className=" hover:text-main transition-all duration-300"
                  >
                    <FaInstagram size={24} />
                  </Link>
                  <Link
                    href={data?.twitter_url}
                    className=" hover:text-main transition-all duration-300"
                  >
                    <FaXTwitter size={24} />
                  </Link>
                  <Link
                    href={data?.snapchat_url}
                    className=" hover:text-main transition-all duration-300"
                  >
                    <FaSnapchatGhost size={24} />
                  </Link>
                </div>
              ) : (
                ""
              )}
            </div>
            {/* links */}
            <div className="lg:col-span-2 col-span-6 space-y-6">
              <h3 className="text-xl font-bold relative pb-4  before:h-[1px] before:w-12 before:bg-gray-400 before:absolute before:bottom-0 before:start-0">
                {f("importantLinks")}
              </h3>
              <ul className="space-y-4">
                <li>
                  <Link href="/" className="hover:text-main">
                    {f("home")}
                  </Link>
                </li>
                <li>
                  <Link href="/about-us" className="hover:text-main">
                    {f("aboutUs")}
                  </Link>
                </li>
                <li>
                  <Link href="/offers" className="hover:text-main">
                    {f("offers")}
                  </Link>
                </li>
                <li>
                  <Link href="/articles" className="hover:text-main">
                    {f("articles")}
                  </Link>
                </li>
                <li>
                  <Link href="/contact" className="hover:text-main">
                    {f("contact")}
                  </Link>
                </li>
              </ul>
            </div>
            {/* app */}
            <div className="lg:col-span-3 col-span-6 space-y-6">
              <h3 className="text-xl font-bold relative pb-4  before:h-[1px] before:w-12 before:bg-gray-400 before:absolute before:bottom-0 before:start-0">
                {f("downloadApp")}
              </h3>
              <div>
                <Link href="#" className="block">
                  <FallbackImage
                    src="/footer/apple.png"
                    alt="ios-logo"
                    className="hover:scale-105 transition-all duration-300 rounded-2xl"
                    width={200}
                    height={50}
                  />
                </Link>
              </div>
              <div>
                <Link href="#" className=" transition-all duration-300 block">
                  <FallbackImage
                    src="/footer/andriod.png"
                    alt="android-logo"
                    width={200}
                    className="hover:scale-105 transition-all duration-300 rounded-2xl"
                    height={50}
                  />
                </Link>
              </div>
            </div>
            {/* input */}
            <div className="lg:col-span-4 md:col-span-6 col-span-12 space-y-6">
              <h3 className="text-xl font-bold relative pb-4  before:h-[1px] before:w-12 before:bg-gray-400 before:absolute before:bottom-0 before:start-0 w-fit mx-auto md:mx-0">
                {f("newsletter")}
              </h3>
              <p className="text-center md:text-start">
                {f("newsletterSignup")}
              </p>
              <NewsLetterOne />
            </div>
          </div>
        </div>
        {/* copyrights */}

        {data?.show_payment_gates == 1 ? (
          <div className="container  border-t py-4 flex items-center md:justify-between justify-center flex-col md:flex-row gap-2">
            {/* payment */}
            <FallbackImage
              src="/footer/payment.png"
              alt="payment"
              width={300}
              height={30}
            />
            {/* roles */}
            <Link
              href={"/terms-and-conditions"}
              className="lg:flex items-center gap-2 text-sm hidden hover:text-main transition-all duration-300"
            >
              <span>{f("termsAndConditions")}</span>
              <Separator orientation="vertical" className="h-6" />
              <span>{f("privacyPolicy")}</span>
            </Link>
            {/* copy rights */}
            <p className="text-sm">
              {f("copyright1")} &copy; {new Date().getFullYear()}{" "}
              <span className="font-bold">Soin</span>. {f("copyright2")}{" "}
              <span className="font-bold text-main">
                <Link href={"https://serv5.com"} target="_blank">
                  Serv5
                </Link>
              </span>
            </p>
          </div>
        ) : (
          ""
        )}
      </div>
    </footer>
  );
};

export default Footerone;
