'use client';
import { Button } from "@/components/ui/button";
import clsx from "clsx";
import { Heart, Loader2 } from 'lucide-react';
import { useLocale, useTranslations } from "next-intl";
import Link from "next/link";
import { IoStar } from "react-icons/io5";
import FallbackImage from "../FallbackImage";
import Rate from "../Rate";


export default function ProductCardRedesign(
   { handleToggleItem,
      handleAddToCart,
      productTitle,
      productPhoto,
      isWishlist,
      isFavLoading,
      product,
      isPending,
      currencyShortname,
      rate,
      h = false
   }) {
   const t = useTranslations("cart");
   const locale = useLocale();


   return (
      <div className={clsx("rounded-lg h-full flex flex-col justify-between group shadow-main border hover:border-main hover:shadow-xl", {
         "grid grid-cols-2 gap-2": h
      })}>
         <div className="relative">
            {
               product.discount &&
               <div dir="ltr" className="absolute top-2 left-2 z-10 flex flex-col gap-2">
                  <span className="bg-main text-white text-xs px-2 py-1 rounded">
                     -{2}%
                  </span>
                  <span className="bg-red-500 text-white text-xs px-2 py-1 rounded">
                     HOT
                  </span>
               </div>
            }
            {/* Wishlist and zoom icons */}
            <div className="absolute opacity-0 invisible group-hover:opacity-100 group-hover:visible transform translate-y-2 group-hover:translate-y-0 transition-all duration-500 ease-in-out top-2 right-4 z-10">
               <button onClick={handleToggleItem} className="bg-white p-2 rounded-full shadow-md hover:bg-gray-100 transition-colors duration-200">
                  {isFavLoading ? (
                     <Loader2 size={20} className="animate-spin" />
                  ) : (

                     <Heart
                        fill={isWishlist ? "#ef4444" : "none"}
                        size={20}
                        className="cursor-pointer transition-colors duration-200"
                     />
                  )}
               </button>
            </div>

            {/* Product Image */}
            <div className="w-full h-48 relative">
               <Link href={`/products/${product.id}`}>
                  <FallbackImage
                     src={productPhoto}
                     alt={productTitle}
                     className="size-full p-4 object-contain"
                     fill
                  />
               </Link>
            </div>
         </div>

         <div className="p-6 space-y-3">
            {/* Product Info */}
            <div>
               <Link
                  href={`/products/${product.id}`}
                  className="text-sm md:text-lg lg:text-xl font-bold hover:text-main line-clamp-1 block"
               >
                  {productTitle}
               </Link>
            </div>
            {/* Rating Stars */}
            <div className="flex gap-3 text-nowrap lg:text-lg">
               {Number(product.rate) > 0 && <span>({Number(product.rate).toFixed(1)})</span>}
               <Rate size={16} rating={product.rate} />
            </div>
            {/* Price */}
            <div className="flex text-sm lg:text-xl 2xl:text-2xl items-center gap-2">
               {
                  product.discount &&
                  <span className="text-red-600 font-bold">
                     {locale === "en" && <span>{currencyShortname}</span>}
                     {' '}{((product.price - (product.price * (product.discount / 100))) * rate).toFixed(2)}{' '}
                     {locale === "ar" && <span>{currencyShortname}</span>}
                  </span>
               }
               <span className={clsx({
                  'text-red-600 font-bold': !product.discount,
                  'line-through text-gray-500': product.discount
               })}>
                  {locale === "en" && <span>{currencyShortname}</span>}
                  {' '}{(product.price * rate).toFixed(2)}{' '}
                  {locale === "ar" && <span>{currencyShortname}</span>}
               </span>
            </div>
            {/* Add to Cart Button */}
            <Button
               variant="outline"
               className="w-full text-sm lg:text-base 2xl:text-lg font-bold"
               onClick={handleAddToCart}
            >
               {isPending ? (
                  <Loader2 size={20} className="animate-spin" />
               ) : (
                  t("add-to-cart")
               )}
            </Button>
         </div>
      </div>

   )
}
