'use client';
import { Button } from "@/components/ui/button";
import clsx from "clsx";
import { Heart, Loader2 } from 'lucide-react';
import { useLocale, useTranslations } from "next-intl";
import Link from "next/link";
import FallbackImage from "../FallbackImage";
import Rate from "../Rate";
import { Check } from 'lucide-react';
import { Card } from "@/components/ui/card";


export default function ProductCardRedesign(
   { handleToggleItem,
      handleAddToCart,
      productTitle,
      productPhoto,
      isWishlist,
      isFavLoading,
      product,
      isPending,
      currency,
      rate,
      h = false,
      line = false
   }) {
   const t = useTranslations("cart");
   const locale = useLocale();

   return (
      <Card dir={locale == 'en' ? 'ltr' : 'rtl'} className={clsx("group/card overflow-hidden rounded-2xl h-full flex flex-col justify-between transition-all duration-500 ease-in-out border hover:border-secondary", {
         "grid grid-cols-2 gap-2": h
      })}>
         <div className="relative">
            {
               product.discount &&
               <div dir="ltr" className="absolute top-2 left-2 z-10 flex flex-col gap-2">
                  <span className="bg-green-600 text-white text-xs px-2 py-1 rounded">
                     -{2}%
                  </span>
               </div>
            }
            {/* Wishlist and zoom icons */}
            <div className="absolute opacity-0 invisible group-hover/card:opacity-100 group-hover/card:visible transform translate-y-2 group-hover/card:translate-y-0 transition-all duration-500 ease-in-out top-2 right-4 z-10">
               <button onClick={handleToggleItem} className={`cursor-pointer p-2 rounded-full shadow-md ${isWishlist ? 'bg-secondary text-white' : 'bg-white hover:bg-secondary hover:text-white'}`}>
                  {
                     isWishlist ? <Check size={20} className="duration-500" /> :
                        isFavLoading ? (
                           <Loader2 size={20} className="animate-spin" />
                        ) : (
                           <Heart
                              size={20}
                              className="duration-500"
                           />
                        )}
               </button>
            </div>

            {/* Product Image */}
            <div className="w-full h-48 relative">
               <Link href={`/products/${product.id}`}>
                  <FallbackImage
                     src={productPhoto}
                     alt={productTitle}
                     className="size-full object-cover rounded-t-2xl transition-all duration-500 ease-in-out transform hover:scale-105"
                     fill
                  />
               </Link>
            </div>
         </div>

         <div className="p-6 space-y-3">
            {/* Product Info */}
            <div>
               <Link
                  href={`/products/${product.id}`}
                  className={`text-sm md:text-lg font-bold duration-500 text-secondary hover:text-pink-600 ${line && 'overflow-hidden text-nowrap text-ellipsis'} block`}
               >
                  {productTitle}
               </Link>
            </div>
            {/* Rating Stars */}
            <div className="flex gap-3 text-nowrap lg:text-lg">
               {Number(product.rate) > 0 && <span className="text-gray-400">({Number(product.rate).toFixed(1)})</span>}
               <Rate rating={product.rate} />
            </div>
            {/* Price */}
            <div className="flex text-sm lg:text-xl items-center gap-2">
               {
                  product.discount &&
                  <span className="text-red-600 font-bold">
                     {currency} {((product.price - (product.price * (product.discount / 100))) * rate).toFixed(2)}
                  </span>
               }
               <span className={clsx({
                  'font-bold': !product.discount,
                  'line-through text-gray-500': product.discount
               })}>
                  {currency} {(product.price * rate).toFixed(2)}
               </span>
            </div>
            {/* Add to Cart Button */}
            <Button
               className="w-full bg-mainDark rounded-full hover:bg-secondary text-white text-sm lg:text-base 2xl:text-lg font-bold"
               onClick={handleAddToCart}
            >
               {isPending ? (
                  <Loader2 size={20} className="animate-spin" />
               ) : (
                  t("add-to-cart")
               )}
            </Button>
         </div>
      </Card>

   )
}
