"use client";
import { Button } from "@/components/ui/button";
import clsx from "clsx";
import { Heart, Loader2 } from "lucide-react";
import { useLocale, useTranslations } from "next-intl";
import Link from "next/link";
import FallbackImage from "../FallbackImage";
import Rate from "../Rate";
import { Check } from "lucide-react";
import { Card } from "@/components/ui/card";

export default function ProductCardRedesignThree({
  handleToggleItem,
  handleAddToCart,
  productTitle,
  productPhoto,
  isWishlist,
  isFavLoading,
  product,
  isPending,
  currency,
  rate,
  h = false,
  line = false,
}) {
  const t = useTranslations("cart");
   const locale = useLocale();
  const hasPrice = !!product?.price;

  return (
    <Card
      dir={locale == "en" ? "ltr" : "rtl"}
      className={clsx(
        "group group/card rounded-md h-full flex flex-col justify-between transition-all duration-500 ease-in-out ",
        {
          "grid grid-cols-2": h,
        }
      )}
    >
      <div className="relative">
        {product.discount && (
          <div
            dir="ltr"
            className="absolute top-2 left-2 z-10 flex flex-col gap-2"
          >
            <span className=" text-red-500 font-semibold text-base p-3 ">
              -{parseFloat(product.discount).toFixed(0)}%
            </span>
          </div>
        )}
        {/* Wishlist and zoom icons */}
        <div className="absolute opacity-0 invisible group-hover/card:opacity-100 group-hover/card:visible transform translate-y-2 group-hover/card:translate-y-0 transition-all duration-500 ease-in-out top-2 right-2 z-10">
          <button
            onClick={handleToggleItem}
            className={`cursor-pointer p-2 rounded-full shadow-md ${
              isWishlist
                ? "bg-secondary text-main"
                : "bg-white hover:bg-secondary hover:text-main"
            }`}
          >
            {isWishlist ? (
              <Heart size={20} className="duration-500" />
            ) : isFavLoading ? (
              <Loader2 size={20} className="animate-spin" />
            ) : (
              <Heart size={20} className="duration-500" />
            )}
          </button>
        </div>

        {/* Product Image */}
        <div className="w-full h-60 relative">
          <Link href={`/products/${product.id}`}>
            <FallbackImage
              src={productPhoto}
              alt={productTitle}
              className="size-full p-2 object-contain hover:!rounded-2xl transition-all duration-500 ease-in-out transform hover:scale-105"
              fill
            />
          </Link>
        </div>
      </div>

      <div className="p-2 space-y-3 flex flex-col justify-center">
        {/* Rating Stars */}
        <div className="flex gap-3 text-nowrap lg:text-lg">
          {Number(product.rate) > 0 && (
            <span className="text-gray-400">
              ({Number(product.rate).toFixed(1)})
            </span>
          )}
          <Rate size={14} rating={product.rate} />
        </div>
        {/* Product Info */}
        <div>
          <Link
            href={`/products/${product.id}`}
            className={`text-sm md:text-lg font-bold duration-500 text-main hover:text-secondary line-clamp-1 text-nowrap text-ellipsis ${
              line && "overflow-hidden text-nowrap text-ellipsis"
            } block`}
          >
            {productTitle}
          </Link>
          {product?.sku && (
            <p className="text-sm sm:text-lg font-bold text-gray-500 my-5">
              {product?.sku}
            </p>
          )}
        </div>

        {/* Price */}
        {hasPrice ? (
          <div className="flex text-lg items-center gap-2">
            {product.discount && (
              <span className="text-red-600 font-semibold">
                {currency}{" "}
                {(
                  (product.price - product.price * (product.discount / 100)) *
                  rate
                ).toFixed(2)}
              </span>
            )}
            <span
              className={clsx({
                "font-semibold": !product.discount,
                "line-through text-gray-500": product.discount,
              })}
            >
              {currency} {(product.price * rate).toFixed(2)}
            </span>
          </div>
        ) : (
          <div className="h-[30px]" />
        )}
        {/* Add to Cart Button */}
        {hasPrice ? (
          <Button
            className="w-full bg-gray-200 rounded-lg group-hover:bg-secondary text-main text-sm lg:text-base 2xl:text-lg font-bold"
            onClick={handleAddToCart}
          >
            {isPending ? (
              <Loader2 size={20} className="animate-spin" />
            ) : (
              t("add-to-cart")
            )}
          </Button>
        ) : (
          <Button asChild>
            <Link href={`/products/${product.id}`}>{t("read-more")}</Link>
          </Button>
        )}
      </div>
    </Card>
  );
}
