import { Loader2 } from "lucide-react";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { FaPlus } from "react-icons/fa";
import { FaSpinner } from "react-icons/fa6";
import { IoMdHeart } from "react-icons/io";
import { IoStar } from "react-icons/io5";
import FallbackImage from "../FallbackImage";

export default function ProductCardUIone({
  handleToggleItem,
  handleAddToCart,
  productTitle,
  productPhoto,
  isWishlisted,
  isFavLoading,
  isPending,
  product,
  currencyShortname,
  rate,
}) {
  const t = useTranslations("cart");

  return (
    <>
      {product ? (
        <div className="rounded-xl border-2 border-gray-100 hover:border-2 hover:border-main bg-gray-100 flex flex-col justify-between h-full p-2 md:p-4 lg:p-8 space-y-4  transition-all duration-300">
          {/* Wishlist and rating */}
          <div className="flex items-center  justify-between">
            <div
              className={`flex items-center gap-2 ${
                isWishlisted ? "text-red-500" : "text-red-300"
              } hover:text-red-500`}
            >
              {isFavLoading ? (
                <FaSpinner className="animate-spin" />
              ) : (
                <IoMdHeart
                  size={22}
                  onClick={handleToggleItem}
                  className="cursor-pointer"
                />
              )}
              {/* Discount */}
              {product.discount && (
                <span className="bg-main text-xs text-white rounded-md p-1">
                  {Math.floor(product.discount)}%
                </span>
              )}
            </div>
          </div>

          {/* Product image and details */}
          <Link href={`/products/${product.id}`} className=" block space-y-4">
            <div className=" h-24 md:h-36 relative">
              <FallbackImage
                src={productPhoto}
                alt={product.title || "product"}
                fill
                className="object-contain"
              />
            </div>
            <div className="text-center space-y-2 3xl:text-xl text-lg">
              <h3 className="font-semibold line-clamp-1">{productTitle}</h3>
              <p className="font-bold space-x-2">
                {parseFloat(
                  (product.price - product.price * (product.discount / 100)) *
                    rate
                ).toFixed(2)}
                &nbsp;
                <span className="text-sm text-main">{currencyShortname}</span>
              </p>
            </div>
          </Link>
          {product.rate && (
            <div className="flex items-center gap-1 justify-center">
              {Array.from({ length: Math.floor(product.rate) }, (_, i) => (
                <IoStar
                  key={`yellow-${i}`}
                  size={16}
                  className="text-yellow-400"
                />
              ))}
              {Array.from({ length: 5 - Math.floor(product.rate) }, (_, i) => (
                <IoStar key={`gray-${i}`} size={16} className="text-gray-300" />
              ))}
              <p className="text-sm font-semibold pt-1">
                {parseFloat(product.rate).toFixed(1)}
              </p>
            </div>
          )}
          {/* Add to cart button */}

          <button
            disabled={isPending}
            onClick={handleAddToCart}
            className="rounded-lg outline outline-[2px] outline-offset-[1px] outline-main   justify-center relative w-[80%] m-auto h-12 cursor-pointer flex items-center border border-bg-gray-200  bg-gray-200 group text-main hover:bg-gray-200  active:bg-gray-200 font-bold active:border-main text-center"
          >
            {isPending ? (
              <Loader2 size={20} className="text-main animate-spin" />
            ) : (
              <>
                <span className="absolute right-0 h-full w-10 rounded-lg bg-main flex items-center justify-center transform group-hover:translate-x-0 group-hover:w-full transition-all duration-300">
                  <FaPlus className="text-white" />
                </span>
                &nbsp;{t("add-to-cart")}
              </>
            )}
          </button>
        </div>
      ) : (
        ""
      )}
    </>
  );
}
