"use client";
import { Loader2 } from "lucide-react";
import Link from "next/link";
import { FaSpinner } from "react-icons/fa6";
import { IoMdHeart } from "react-icons/io";
import { IoStar } from "react-icons/io5";
import { TbShoppingBagPlus } from "react-icons/tb";
import FallbackImage from "../FallbackImage";
import { useTranslations } from "next-intl";
import { FaPlus } from "react-icons/fa";
import { IoCartOutline } from "react-icons/io5";
import { LuEye } from "react-icons/lu";
import { toastError, toastSuccess } from "@/services/custom-toast";
import { useRouter } from "next/navigation";

export default function ProductCardUIthree({
  handleToggleItem,
  handleAddToCart,
  productTitle,
  productPhoto,
  isWishlisted,
  isFavLoading,
  isPending,
  product,
  currencyShortname,
  rate,
}) {
  const t = useTranslations("cart");
  const router = useRouter();
 
  return (
    <>
      {product ? (
        <div className="group cursor-pointer bg-white border rounded-xl flex flex-col justify-between h-full p-2 md:p-4 lg:p-4 space-y-4  transition-all duration-300">
          {/* Product image and details */}
          <div className="flex flex-col space-y-8">
            <div className="h-24 md:h-48 relative overflow-hidden">
              <FallbackImage
                src={productPhoto}
                alt={product.title || "product"}
                fill
                className="object-contain"
              />
              {/* Add to cart button */}
              <div className="flex items-center justify-center gap-2 absolute -bottom-20 inset-x-0 group-hover:bottom-2 transition-all duration-300 ">
                {/* Wishlist and rating */}
                <div className="flex items-center justify-center ">
                  <div
                    className={`flex items-center gap-2 ${
                      isWishlisted ? "text-main" : "text-main/50"
                    } hover:text-main`}
                  >
                    {isFavLoading ? (
                      <div className="border-2 rounded-md cursor-pointer size-10 flex justify-center items-center bg-white">
                        <FaSpinner size={20} className="animate-spin" />
                      </div>
                    ) : (
                      <div className="border-2 rounded-md cursor-pointer size-10 flex justify-center items-center bg-white">
                        <IoMdHeart
                          size={20}
                          onClick={handleToggleItem}
                          className="  "
                        />
                      </div>
                    )}
                  </div>
                </div>
                {/* single product  */}
                <Link
                  href={`/products/${product.id}`}
                  className="text-main/50 hover:text-main border-2 rounded-md cursor-pointer size-10 flex justify-center items-center bg-white"
                >
                  <LuEye size={20} />
                </Link>
                {/* add to cart */}
                <div
                  disabled={isPending}
                  onClick={() => {
                    if (product.has_form) {
                      toastError(t("product-has-form"));
                      return router.push(`/products/${product.id}`);
                    }
                    handleAddToCart();
                  }}
                  className="text-main/50 hover:text-main border-2 rounded-md cursor-pointer size-10 flex justify-center items-center bg-white"
                >
                  {isPending ? (
                    <Loader2 size={20} className="text-main animate-spin" />
                  ) : (
                    <>
                      <IoCartOutline size={20} />
                    </>
                  )}
                </div>
              </div>
            </div>
            <div className="text-center flex-grow min-h-12 space-y-2 3xl:text-xl text-lg">
              <h3 className="font-semibold line-clamp-1">{productTitle}</h3>
            </div>
          </div>
          <div className="flex items-center justify-center gap-x-10 ">
            {product.rate && (
              <div className="flex items-center gap-1 justify-center">
                {Array.from({ length: Math.floor(product.rate) }, (_, i) => (
                  <IoStar
                    key={`yellow-${i}`}
                    size={16}
                    className="text-yellow-400"
                  />
                ))}
                {Array.from(
                  { length: 5 - Math.floor(product.rate) },
                  (_, i) => (
                    <IoStar
                      key={`gray-${i}`}
                      size={16}
                      className="text-gray-300"
                    />
                  )
                )}
              </div>
            )}
            <p className="font-bold space-x-2">
              {parseFloat(
                (product.price - product.price * (product.discount / 100)) *
                  rate
              ).toFixed(2)}
              &nbsp;
              <span className="text-sm text-main">{currencyShortname}</span>
            </p>
          </div>
        </div>
      ) : (
        ""
      )}
    </>
  );
}
