import { Loader2 } from "lucide-react";
import Link from "next/link";
import { FaSpinner } from "react-icons/fa6";
import { IoMdHeart } from "react-icons/io";
import { IoStar } from "react-icons/io5";
import { TbShoppingBagPlus } from "react-icons/tb";
import FallbackImage from "../FallbackImage";
import { useTranslations } from "next-intl";
import { FaPlus } from "react-icons/fa";

export default function ProductCardUItwo(
    { handleToggleItem,
        handleAddToCart,
        productTitle,
        productPhoto,
        isWishlisted,
        isFavLoading,
        isPending,
        product,
        currencyShortname,
        rate }) {
    const t = useTranslations("cart");

    return (
        <>
            {
                product ?
                    <div className="  bg-white border-[1px] flex flex-col justify-between h-full p-2 md:p-4 lg:p-4 space-y-4  transition-all duration-300">


                        {/* Product image and details */}
                        <Link href={`/products/${product.id}`} className=" block space-y-4">
                            <div className=" h-24 md:h-36 relative">
                                <FallbackImage
                                    src={productPhoto}
                                    alt={product.title || "product"}
                                    fill
                                    className="object-contain"
                                />
                            </div>
                            <div className="text-center space-y-2 3xl:text-xl text-lg">
                                <h3 className="font-semibold line-clamp-1">{productTitle}</h3>
                            </div>
                        </Link>
                        <div className="flex items-center justify-center gap-x-10 ">

                            {product.rate && (
                                <div className="flex items-center gap-1 justify-center">
                                    {Array.from({ length: Math.floor(product.rate) }, (_, i) => (
                                        <IoStar
                                            key={`yellow-${i}`}
                                            size={16}
                                            className="text-yellow-400"
                                        />
                                    ))}
                                    {Array.from({ length: 5 - Math.floor(product.rate) }, (_, i) => (
                                        <IoStar key={`gray-${i}`} size={16} className="text-gray-300" />
                                    ))}

                                </div>
                            )}
                            <p className="font-bold space-x-2">
                                {parseFloat(
                                    (product.price - product.price * (product.discount / 100)) * rate
                                ).toFixed(2)}
                                &nbsp;<span className="text-sm text-main">{currencyShortname}</span>
                            </p>
                        </div>

                        {/* Add to cart button */}
                        <div className="flex items-center justify-between gap-2">
                            {/* Wishlist and rating */}
                            <div className="flex items-center  justify-between ">
                                <div
                                    className={`flex items-center gap-2 ${isWishlisted ? "text-main" : "text-main/50"
                                        } hover:text-main`}
                                >
                                    {isFavLoading ? (
                                        <div className="border-2 cursor-pointer h-12 w-12 flex justify-center items-center">

                                            <FaSpinner className="animate-spin" />
                                        </div>
                                    ) : (
                                        <div className="border-2 cursor-pointer h-12 w-12 flex justify-center items-center">
                                            <IoMdHeart
                                                size={22}
                                                onClick={handleToggleItem}
                                                className="  "
                                            />
                                        </div>
                                    )}
                                    {/* Discount */}
                                    {product.discount && (
                                        <span className="bg-main text-xs text-white rounded-md p-1">
                                            {Math.floor(product.discount)}%
                                        </span>
                                    )}
                                </div>

                            </div>
                            <button
                                disabled={isPending}
                                onClick={handleAddToCart}
                                className="   justify-center relative w-full btn btn-main rounded-none m-auto h-12 cursor-pointer flex items-center bg-main text-white"
                            >
                                {isPending ? (
                                    <Loader2 size={20} className="text-main animate-spin" />
                                ) : (
                                    <>
                                        &nbsp;{t("add-to-cart")}
                                    </>
                                )}
                            </button>
                        </div>

                    </div>
                    : ""
            }
        </>
    )
}
