import { getTranslations } from "next-intl/server";
import Link from "next/link";
import { FaArrowRight } from "react-icons/fa";
import FallbackImage from "../FallbackImage";

const BlogCardRedesign = async ({ blog }) => {
  const t = await getTranslations("single-article");
  return (
    <div className="hover:bg-white bg-lightmain group hover:shadow transition-all duration-300 rounded-md overflow-hidden">
      <div className="overflow-hidden">
        <FallbackImage
          width={600}
          height={300}
          src={blog.image}
          alt={blog.title}
          className="object-cover group-hover:scale-110 duration-500 transition-all w-full h-36 md:h-64"
        />
      </div>
      <div className=" p-3 md:p-6 space-y-4">
        <div className="">
          <Link
            href={`/articles/${blog.id}`}
            className="text-xl font-bold line-clamp-1 hover:text-main"
          >
            {blog.title}
          </Link>
        </div>
        <div
          className="line-clamp-2 text-secondary leading-loose"
          dangerouslySetInnerHTML={{
            __html: blog.excerpt || "", // Ensure content is not undefined
          }}
        ></div>
        {/* </p> */}
        <div className="flex items-center justify-between ">
          {/* link */}
          <Link
            href={`/articles/${blog.id}`}
            className="bg-main text-white hover:bg-transparent hover:text-main transition-all duration-300 p-3 border-[2px] border-main hover:border-[2px] hover:border-main  flex  items-center gap-2 text-sm font-bold rounded-md"
          >
            <FaArrowRight size={16} />
            {t("readMore")}
          </Link>
        </div>
      </div>
    </div>
  );
};

export default BlogCardRedesign;
