import { getTranslations } from "next-intl/server";
import Link from "next/link";
import FallbackImage from "../FallbackImage";

const BlogCardRedesignThree = async ({ blog }) => {
  const t = await getTranslations("single-article");
  let lastEditDate = null;
  if (blog.last_edit_date) {
    const dateObj = new Date(blog.last_edit_date);
    lastEditDate = dateObj.toISOString().split("T")[0]; // Formats as YYYY-MM-DD
  }
  return (
    <div className="bg-white group shadow transition-all duration-300 rounded-md overflow-hidden">
      <div className=" relative">
        <div className="overflow-hidden w-full full">
          <FallbackImage
            width={600}
            height={300}
            src={blog.image}
            alt={blog.title}
            className="object-cover group-hover:scale-110 duration-500 transition-all w-full h-36 md:h-64"
          />
        </div>
        {lastEditDate && (
          <div className="bg-secondary py-1 translate-y-1/3 z-10 px-3  absolute bottom-0 rounded-md right-2 font-bold text-black">
            <h1>{lastEditDate}</h1>
          </div>
        )}
      </div>
      <div className=" p-3 md:p-6 space-y-4">
        <div className="">
          <Link
            href={`/articles/${blog.id}`}
            className="text-xl font-bold line-clamp-1 hover:text-main"
          >
            {blog.title}
          </Link>
        </div>
        <div
          className="line-clamp-2  leading-loose"
          dangerouslySetInnerHTML={{
            __html: blog.excerpt || "", // Ensure content is not undefined
          }}
        ></div>
        {/* </p> */}
        <div className="flex items-center justify-between ">
          {/* link */}
          <Link
            href={`/articles/${blog.id}`}
            className="bg-main w-full justify-center text-white hover:bg-secondary hover:text-main  transition-all duration-300 p-3  flex  items-center gap-2 text-sm font-bold rounded-md"
          >
            {t("readMore")}
          </Link>
        </div>
      </div>
    </div>
  );
};

export default BlogCardRedesignThree;
