"use client";
import Link from "next/link";
import FallbackImage from "./FallbackImage";
// BY MOHAMMED HOSSAM
// DATA 25-11-2024
// A CARD USED IN CATEGORIES AND BRANDS
const BrandCatCard = ({ item, styleData, imageClass, isBrand }) => {
  return (
    <Link
      href={`${isBrand ? `/brands/${item.id}` : `products/filter/${item.id}`}`}
      dir="rtl"
      className="relative group block h-56 lg:h-56  overflow-hidden transition-all duration-200 ease-in-out"
    >
      {/* Circle in the Top-Right Corner */}
      <div
        className="absolute border top-[-70px] md:top-[-40px] right-[-35px] md:right-[-35%] xl:top-[-80px] xl:right-[-80px] w-60 h-60 md:w-80 md:h-80 2xl:w-80 2xl:h-80 flex items-center justify-center rounded-full transition-transform duration-300 ease-in-out"
        style={{
          border: `2px solid ${styleData.circleColor}`,
          backgroundColor: "transparent",
        }}
      >
        <div
          className="w-52 h-52 md:w-64 md:h-64 2xl:w-72 2xl:h-72 rounded-full transition-colors duration-300 ease-in-out"
          style={{
            backgroundColor: styleData.circleColor,
          }}
        />
      </div>

      {/* Content */}
      <div
        className="flex items-center max-md:flex-col justify-around h-full transition-colors duration-300 ease-in-out"
        style={{
          backgroundColor: styleData.bgColor,
        }}
      >
        {/* Product Image */}
        <FallbackImage
          src={item.image || item.cover_image}
          alt={item.title || "image"}
          width={550}
          height={500}
          className={`w-[150px] relative z-[5] rounded-tr-lg h-[130px] object-contain ${imageClass}`}
        />

        {/* Button */}
        <div className="relative transition-all duration-200 ease-in-out">
          <span
            className="px-8 py-2 lg:py-3 text-white font-bold text-lg shadow-lg transition-transform transform bg-transparent group-hover:border-2 rounded-lg group-hover:scale-105 group-hover:border-main group-hover:shadow-main/50 group-hover:shadow-md focus:outline-none"
            style={{
              backgroundColor: styleData.bgTitle,
              color: styleData.textColor,
            }}
          >
            {item.title || item.name}
          </span>
        </div>
      </div>
    </Link>
  );
};

export default BrandCatCard;
