"use client";
import Link from "next/link";
import FallbackImage from "./FallbackImage";
// BY MOHAMMED HOSSAM
// DATA 25-11-2024
// A CARD USED IN CATEGORIES AND BRANDS
const BrandCatCardRedesignTwo = ({ item, imageClass, isBrand }) => {
  return (
    <Link
      href={`${isBrand ? `/brands/${item.id}` : `products/filter/${item.id}`}`}
      dir="rtl"
      className="relative group block rounded-md shadow-lg overflow-hidden transition-all duration-700 ease-in-out"
    >
      {/* Content */}
      <div
        className="flex items-center bg-white rounded-md max-md:flex-col justify-around h-full transition-all duration-700 ease-in-out"
      >
        {/* Product Image */}
        <FallbackImage
          src={item.image || item.cover_image}
          alt={item.title || "image"}
          width={550}
          height={500}
          className={`w-[150px] relative z-[5] rounded-tr-lg h-[130px] object-contain ${imageClass}`}
        />

        {/* Button */}
        <div className="relative min-w-[150px] p-2 max-lg:w-full lg:rounded-lg text-center bg-secondary text-white">
          <span className="text-lg relative z-[4] font-semibold text-foreground transition-all duration-700 group-hover:text-primary">
            {item.title || item.name}
          </span>

          {/* Dot Expansion on Hover */}
          <div className="h-full w-full rounded-lg group-hover:scale-[6] group-hover:w-full group-hover:h-full transition-all duration-700 ease-in-out bg-secondary absolute top-0 right-0"></div>

          {/* Underline Expansion */}
          <span className="absolute bottom-0 left-0 h-0.5 w-0 bg-primary transition-all duration-700 group-hover:w-full" />
        </div>
      </div>
    </Link>
  );
};

export default BrandCatCardRedesignTwo;
