import fetchData from "@/api/fetch-data";
import { getLocale } from "next-intl/server";
import BrandSliderRedesign from "./BrandSliderRedesign";
import BrandSliderRedesignTwo from "../BrandSectionRedesignTwo/BrandSliderRedesignTwo";

export default async function BrandSectionRedesignTwo() {
  const locale = await getLocale();
  let brands;
  const response = await fetchData({ endPoint: "/brands", locale: locale });

  if (response?.status == "success") {
    brands = response?.data?.slice(0, 6);
  }

  return (
    // <BrandSliderRedesignTwo brands={brands} locale={locale} />
    <BrandSliderRedesign brands={brands} locale={locale} />
  );
}
