"use client";
import { categories } from "@/api/categories/Categories";
import {
    Carousel,
    CarouselContent,
    CarouselItem,
} from "@/components/ui/carousel";
import { useSettings } from "@/stores/settings";
import clsx from "clsx";
import Autoplay from "embla-carousel-autoplay";
import { useLocale } from "next-intl";
import { useEffect, useState } from 'react';
import BrandCatCard from "../BrandCatCard";
import Link from "next/link";
import FallbackImage from "../FallbackImage";


const BrandSliderRedesign = ({ brands }) => {

    const locale = useLocale()
    const [api, setApi] = useState();
    const [currentSlide, setCurrentSlide] = useState(0);
    const [totalSlides, setTotalSlides] = useState(0);
    const { settings } = useSettings();
    // shadcn ui curasol dots
    useEffect(() => {
        if (!api) {
            return;
        }
        setTotalSlides(api.slideNodes().length);
        api.on("select", () => {
            setCurrentSlide(api.selectedScrollSnap())
        })
    }, [api])



    return (
        <div className="container ">
            {brands && brands.length > 0 && settings?.site_settings?.show_brands == 1 ?
                <>


                    <div className=" ">
                        <Carousel
                            className="w-full "
                            setApi={setApi}
                            dir="ltr"
                            opts={{
                                loop: true,
                                watchSlides: false,
                                align: "start",
                            }}
                            plugins={[
                                Autoplay({
                                    delay: 3500,
                                }),
                            ]}
                        >
                            <CarouselContent >
                                {brands.map((item, index) => {
                                    return (
                                        <CarouselItem key={item.id || index} className="basis-1/3  lg:basis-1/5 ">
                                            <Link
                                                href={`/brands/${item.id}`}
                                                dir="rtl"
                                                className="relative group block h-56 lg:h-56 filter grayscale hover:grayscale-0  overflow-hidden transition-all duration-200 ease-in-out"
                                            >
                                                {/* Content */}
                                                <div
                                                    className="flex items-center max-md:flex-col justify-around h-full transition-colors duration-300 ease-in-out"
                                                >
                                                    {/* Product Image */}
                                                    <FallbackImage
                                                        src={item.image}
                                                        alt={item.title || "image"}
                                                        width={550}
                                                        height={500}
                                                        className={`w-[130px] relative z-[5] rounded-tr-lg h-[130px] object-contain `}
                                                    />
                                                </div>
                                            </Link>
                                        </CarouselItem>
                                    );
                                })}
                            </CarouselContent>
                        
                        </Carousel>
                    </div>
                </> : ""
            }

        </div>
    );
};

export default BrandSliderRedesign;







