"use client";
import {
    Carousel,
    CarouselContent,
    CarouselItem,
} from "@/components/ui/carousel";
import { useSettings } from "@/stores/settings";
import Autoplay from "embla-carousel-autoplay";
import Link from "next/link";
import { useEffect, useState } from 'react';
import FallbackImage from "../FallbackImage";


const BrandSliderRedesignTwo = ({ brands }) => {
    const { settings } = useSettings();
    // shadcn ui curasol dots




    return (
        <div className="container rounded-xl bg-white">
            {brands && brands.length > 0 && settings?.site_settings?.show_brands == 1 ?
                <>
                    <div className=" ">
                        <Carousel
                            className="w-full "
                            dir="ltr"
                            opts={{
                                loop: true,
                                watchSlides: false,
                                align: "start",
                            }}
                            plugins={[
                                Autoplay({
                                    delay: 3500,
                                }),
                            ]}
                        >
                            <CarouselContent >
                                {brands.map((item, index) => {
                                    return (
                                        <CarouselItem key={item.id || index} className="basis-1/3  lg:basis-1/5 ">
                                            <Link
                                                href={`/brands/${item.id}`}
                                                dir="rtl"
                                                className="relative group hover:scale-105 duration-500 transition-all block h-44 lg:h-48  overflow-hidden "
                                            >
                                                {/* Content */}
                                                <div
                                                    className="flex items-center max-md:flex-col justify-around h-full transition-colors duration-300 ease-in-out"
                                                >
                                                    {/* Product Image */}
                                                    <FallbackImage
                                                        src={item.image}
                                                        alt={item.title || "image"}
                                                        width={550}
                                                        height={500}
                                                        className={`w-[130px] relative z-[5] rounded-tr-lg h-[130px] object-contain `}
                                                    />
                                                </div>
                                            </Link>
                                        </CarouselItem>
                                    );
                                })}
                            </CarouselContent>

                        </Carousel>
                    </div>
                </> : ""
            }

        </div>
    );
};

export default BrandSliderRedesignTwo;







