"use client"
import {
  HoverCard,
  HoverCardContent,
  HoverCardTrigger,
} from "@/components/ui/hover-card"
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { FaArrowRight, FaBars } from "react-icons/fa";
import Link from "next/link";
import { useLocale, useTranslations } from "next-intl";
import { IoIosArrowForward, IoIosArrowBack } from "react-icons/io";
import FallbackImage from "./FallbackImage";
import { useEffect, useState } from "react";
import fetchData from "@/api/fetch-data";
export default function CategoriesMenu({ response }) {
  const locale = useLocale();
  const [showDropdown, setShowDropdown] = useState(false);
  const [categories, setCategories] = useState([]);
  const t = useTranslations('navbar');



  useEffect(() => {
    async function getCategories() {
      const response = await fetchData({ endPoint: "/categories", locale });
      if (response?.status == "success") {
        setCategories(response?.data || []);
      }
    }
    getCategories()
  }, [locale]);

  return (
    <div>
      <DropdownMenu open={showDropdown} onOpenChange={setShowDropdown} modal={false}>
        <DropdownMenuTrigger className="lg:w-48 w-full btn bg-main text-white flex items-center gap-2 rounded-none data-[state=open]:bg-btnColor hover:shadow-md">
          <FaBars size={22} />
          {t('categories')}
        </DropdownMenuTrigger>
        {categories?.length == 0 ?
          <DropdownMenuContent className="w-48  rounded-none  p-4">
            <p className="text-center">{t('no-sections')}</p>
          </DropdownMenuContent>
          :
          <DropdownMenuContent className="w-48  rounded-none p-2 max-md:max-h-64 max-md:overflow-y-auto ">
            {
              categories?.slice(0, 4)?.map((item, index) => (
                <HoverCard key={item.id} openDelay={100} closeDelay={100} >
                  <HoverCardTrigger onClick={() => setShowDropdown(false)}>
                    <Link href={`/products/filter/${item.id}`} className="group my-6 flex items-center gap-1  hover:text-main text-sm cursor-pointer" dir={locale == "en" ? "ltr" : "rtl"} >
                      {locale == "en" ? <IoIosArrowBack className="group-hover:-rotate-90" /> : <IoIosArrowForward className="duration-500 group-hover:rotate-90 text-main" />}
                      <p className="text-base line-clamp-1">
                        {item.title}
                      </p>
                      <FallbackImage
                        src={item.image}
                        alt={item.title}
                        width={18}
                        height={18}
                        className="ms-auto"
                      />
                    </Link>
                  </HoverCardTrigger>
                  <HoverCardContent className={`lg:absolute ${locale == "ar" ?
                    "lg:start-[100px]" : "lg:end-[100px]"} -top-7 rounded-none`}>
                    {/* <h2 className="text-xl font-bold text-main text-center my-4" >{item.title}</h2> */}
                    {item.sub_categories.length == 0 ? <p className="text-center">{t('no-sections')}</p> :
                      <ul dir={locale == "en" ? "ltr" : "rtl"} className="space-y-4">
                        {item?.sub_categories?.map((item) => (
                          <li key={item.id} onClick={() => setShowDropdown(false)} className="flex items-center">
                            <Link href={`/products/filter/${item.id}`} className=" hover:text-main">
                              {item.title}
                            </Link>
                            <FallbackImage
                              src={item.image}
                              alt={item.title}
                              width={18}
                              height={18}
                              className="ms-auto" />
                          </li>
                        ))}
                      </ul>
                    }
                  </HoverCardContent>
                </HoverCard>
              ))
            }
            <div className="  w-fit  hover:text-main m-auto ">
              <Link href={'/categories'} onClick={() => setShowDropdown(false)} className=" flex gap-1 group items-center justify-center">{t('allcategories')}
                <IoIosArrowForward className="text-main group-hover:animate-bounce" /></Link>
            </div>
          </DropdownMenuContent>
        }
      </DropdownMenu>
    </div >
  )

}

