"use client";
import { Button } from "@/components/ui/button";
import {
  Form,
  FormControl,
  FormField,
  FormItem,
  FormMessage,
} from "@/components/ui/form";
import { Input } from "@/components/ui/input";
import { Clock3, House, Loader2, Mail, Phone } from "lucide-react";
import { useLocale, useTranslations } from "next-intl";

export default function ContactRedesignThree({
  data,
  form,
  onSubmit,
  isSubmitting,
}) {
  const label = useTranslations("form-labels");
  const t = useTranslations("contact");
  const settings = data?.data?.site_settings;
  return (
    <section className="container my-12">
      {/* Contact Form */}
      <div className="grid grid-cols-1 lg:grid-cols-2 gap-5">
        {/* Contact Information Cards */}
        {data && data.status === "success" ? (
          <div className="space-y-6 max-md:my-5">
            <h2 className="text-center lg:text-start text-base text-main md:text-xl lg:text-2xl mb-5 font-semibold">
              {t("call_us")}
            </h2>
            <ul className="space-y-4">
              <li className="flex items-center gap-6">
                <House className="size-6 text-main" />
                <span>{settings?.address}</span>
              </li>
              <li className="flex items-center gap-6">
                <Phone className="size-6 text-main" />
                <span>{settings?.phone1}</span>
              </li>
              <li className="flex items-center gap-6">
                <Phone className="size-6 text-main" />
                <span>{settings?.phone2}</span>
              </li>
              <li className="flex items-center gap-6">
                <Mail className="size-6 text-main" />
                <span>{settings?.email}</span>
              </li>
              <li className="flex items-center gap-6">
                <Clock3 className="size-6 text-main" />
                <span>{settings?.work_time}</span>
              </li>
            </ul>
          </div>
        ) : (
          ""
        )}

        <div>
          <h1 className="text-center lg:text-start text-base text-main md:text-xl lg:text-2xl mb-5 font-semibold">
            {t("contact_us")}
          </h1>
          <Form {...form}>
            <form
              method="post"
              onSubmit={form.handleSubmit(onSubmit)}
              className="space-y-4"
            >
              <div className="grid grid-cols-1 md:grid-cols-2 items-center gap-4">
                <FormField
                  name="message"
                  control={form.control}
                  render={({ field }) => (
                    <FormItem>
                      <FormControl>
                        <Input
                          className="w-full text-black"
                          {...field}
                          placeholder={label("question")}
                        />
                      </FormControl>
                      <FormMessage />
                    </FormItem>
                  )}
                />
                <FormField
                  name="subject"
                  control={form.control}
                  render={({ field }) => (
                    <FormItem>
                      <FormControl>
                        <Input
                          className=" w-full text-black"
                          {...field}
                          placeholder={label("subject")}
                        />
                      </FormControl>
                      <FormMessage />
                    </FormItem>
                  )}
                />
              </div>

              <FormField
                name="name"
                control={form.control}
                render={({ field }) => (
                  <FormItem className="w-full">
                    <FormControl>
                      <Input
                        className="  text-black "
                        {...field}
                        placeholder={label("name")}
                      />
                    </FormControl>
                    <FormMessage />
                  </FormItem>
                )}
              />
              <FormField
                name="email"
                className=""
                control={form.control}
                render={({ field }) => (
                  <FormItem className="w-full">
                    <FormControl className="">
                      <Input
                        className=" w-full block  text-black"
                        {...field}
                        placeholder={label("email")}
                      />
                    </FormControl>
                    <FormMessage />
                  </FormItem>
                )}
              />
              <Button
                disabled={isSubmitting}
                type="submit"
                className="bg-secondary w-32 lg:w-44 rounded-sm lg:text-xl text-main  hover:bg-main duration-700 hover:border-main  hover:text-white"
              >
                {isSubmitting ? <Loader2 className="animate-spin" /> : ""}
                &nbsp; &nbsp;
                {label("send")}
              </Button>
            </form>
          </Form>
        </div>
      </div>
      {/* Google Maps Iframe */}
      <div className="rounded-xl lg:mt-10 my-2 overflow-hidden">
        <iframe
          src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d54686.03954861838!2d31.421235199999998!3d31.057510399999995!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2seg!4v1729583062774!5m2!1sen!2seg"
          width="600"
          height="450"
          style={{ border: 0 }}
          allowFullScreen
          className="w-full max-md:h-[30vh]"
          loading="lazy"
          referrerPolicy="no-referrer-when-downgrade"
        />
      </div>
    </section>
  );
}
