"use client";
import { Button } from "@/components/ui/button";
import {
  Form,
  FormControl,
  FormField,
  FormItem,
  FormMessage,
} from "@/components/ui/form";
import { Input } from "@/components/ui/input";
import { Loader2 } from "lucide-react";
import { useTranslations } from "next-intl";
import { BsArrowRight } from "react-icons/bs";

// Contact Information Card Component
const Card = ({ title, desc, textBottom, btnText, link }) => {
  return (
    <div
      className=" w-full  flex flex-col  justify-between items-center flex-wrap gap-y-2 gap-x-5
         2xl:gap-x-10 rounded-sm"
    >
      {/* Card Content */}
        <h2 className="font-bold text-xl xl:text-2xl ">{title || ""}</h2>
        <p className="text-[#5F6C72] text-lg xl:text-xl">{desc || ""}</p>
        <h4 className="text-[#191C1F] text-xl xl:text-2xl font-semibold">
          {textBottom || ""}
        </h4>
        <a
          href={link || ""}
          className="bg-black w-32 block lg:w-44 py-2 text-center rounded-sm lg:text-xl text-white  hover:bg-secondary duration-700 hover:border-black  hover:text-white"
        >
          {btnText || ""}
        </a>

    </div>
  );
};

export default function ContactUiRedesignTwo({ data, form, onSubmit, isSubmitting }) {

  const label = useTranslations("form-labels");
  const t = useTranslations("contact");




  return (
    <section>
      <div className="container ">
        {/* Google Maps Iframe */}
        <div className="rounded-xl lg:mt-10 my-2 overflow-hidden">
          <iframe
            src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d54686.03954861838!2d31.421235199999998!3d31.057510399999995!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2seg!4v1729583062774!5m2!1sen!2seg"
            width="600"
            height="450"
            style={{ border: 0 }}
            allowFullScreen
            className="w-full max-md:h-[30vh]"
            loading="lazy"
            referrerPolicy="no-referrer-when-downgrade"
          />
        </div>
        {/* Contact Form */}
        <div className="flex gap-2 lg:p-10 m-5  lg:lg:m-20 flex-wrap  justify-between items-center">
          {/* Contact Information Cards */}
          {data && data.status === "success" ? (
            <div className="flex gap-5  flex-col max-md:my-5 max-xl:w-full ">
              <Card
                btnText={t("contact_us")}
                imageSrc="/contact/texticon.png"
                icon={<BsArrowRight className="text-xl" />}
                textBottom={data.data?.site_settings.email}
                title={t("support_number")}
                link={`mailto:${data?.data?.site_settings.email}`}
                // desc='Available from 5:00 PM to 9:00 AM'
                desc={data.data?.site_settings?.work_time && (`${t('avaliable')} :  ${data.data?.site_settings?.work_time}`)}
              />
              <Card
                btnText={t("call_us")}
                imageSrc="/contact/phoneicon.png"
                icon={<BsArrowRight className="text-xl" />}
                textBottom={`${data?.data?.site_settings?.phone1} - ${data.data?.site_settings?.phone2}`}
                title={t("call_us")}
                link={`tel:${data.data?.site_settings?.phone1}`}
              />
            </div>
          ) : ""}
          <div className=" m-auto "  >
              <h1 className=" text-3xl 2xl:text-4xl mb-5 font-semibold text-center">
                {t("contact_us")}
              </h1>
            <Form {...form}>
              <form
                method="post"
                onSubmit={form.handleSubmit(onSubmit)}
                className="flex  flex-col items-center  gap-4 justify-center"
              >
                <div className="flex  items-center  gap-4">
                  <FormField
                    name="message"
                    control={form.control}
                    render={({ field }) => (
                      <FormItem>
                        <FormControl>
                          <Input
                            className="  w-full text-black xl:w-[20rem] 3xl:w-[30rem] "
                            {...field}
                            placeholder={label("question")}
                          />
                        </FormControl>
                        <FormMessage />
                      </FormItem>
                    )}
                  />
                  <FormField
                    name="subject"
                    control={form.control}
                    render={({ field }) => (
                      <FormItem>
                        <FormControl>
                          <Input
                            className=" w-full text-black xl:w-[20rem] 3xl:w-[30rem]"
                            {...field}
                            placeholder={label("subject")}
                          />
                        </FormControl>
                        <FormMessage />
                      </FormItem>
                    )}
                  />
                </div>

                <FormField
                  name="name"
                  control={form.control}
                  render={({ field }) => (
                    <FormItem className="w-full">
                      <FormControl>
                        <Input
                          className="  text-black "
                          {...field}
                          placeholder={label("name")}
                        />
                      </FormControl>
                      <FormMessage />
                    </FormItem>
                  )}
                />
                <FormField
                  name="email"
                  className=""
                  control={form.control}
                  render={({ field }) => (
                    <FormItem className="w-full">
                      <FormControl className="">
                        <Input
                          className=" w-full block  text-black"
                          {...field}
                          placeholder={label("email")}
                        />
                      </FormControl>
                      <FormMessage />
                    </FormItem>
                  )}
                />
                <Button
                  disabled={isSubmitting}
                  type="submit"
                  className="bg-black w-32  lg:w-44 rounded-sm lg:text-xl text-white  hover:bg-secondary duration-700 hover:border-black  hover:text-white"
                >
                  {isSubmitting ? (
                    <Loader2 className="animate-spin" />
                  ) : (
                    <></>
                  )}
                  &nbsp; &nbsp;
                  {label("send")}
                </Button>
              </form>
            </Form>
          </div>
        </div>
      </div>
    </section>
  );
}
