'use client';
import { useCurrency } from "@/stores/currency-state";
import { useLocale } from "next-intl";

/**
 * @author: Ahmed Badran
 * Created At: 27-10-2024
 * 
 * CurrencyFormat is a React component that displays a formatted currency value
 * based on the current locale and currency.
 *
 * @param {Object} props - The component props.
 * @param {number} props.value - The numeric value to be formatted as currency.
 * @param {string} props.className - Optional CSS class for styling the component.
 *
 * @returns {JSX.Element} A paragraph element containing the formatted currency.
 */
export default function CurrencyFormat({ value, className }) {
   const { currency } = useCurrency();
   const locale = useLocale();

   let currencyFormat = new Intl.NumberFormat(locale, {
      style: 'currency',
      currency,
   });
   return (
      <p className={className}>{currencyFormat.format(value)}</p>
   );
}