"use client";

import {
  Breadcrumb,
  BreadcrumbItem,
  BreadcrumbLink,
  BreadcrumbList,
  BreadcrumbSeparator,
} from "@/components/ui/breadcrumb";
import clsx from "clsx";
import { Slash } from "lucide-react";
import { useTranslations } from "next-intl";
import { usePathname } from "next/navigation";

export default function CustomBreadcrumb({
  route,
  subs = false,
  title,
  number = 1,
}) {
  const t = useTranslations("links");
  // Split routes from url as array.
  let [, ...pathnames] = usePathname().split("/");
  pathnames = subs ? pathnames.slice(0, -number) : pathnames;
  const placeholder = pathnames[pathnames.length - 1];
  title = title ? title : t(placeholder);

  return (
    <section className="bg-gray-100 py-5">
      <div className="container">
        <Breadcrumb>
          <BreadcrumbList className="text-gray-400 text-lg">
            <BreadcrumbItem>
              <BreadcrumbLink href="/">{t("home")}</BreadcrumbLink>
            </BreadcrumbItem>
            {pathnames.map((path, index) => (
              <div
                key={index}
                className={clsx("flex items-center gap-2", {
                  "text-black": index == pathnames.length - 1 && !route,
                })}
              >
                <BreadcrumbSeparator>
                  <Slash />
                </BreadcrumbSeparator>
                <BreadcrumbItem>
                  <BreadcrumbLink>{t(path)}</BreadcrumbLink>
                </BreadcrumbItem>
              </div>
            ))}
            {route && (
              <>
                <BreadcrumbSeparator>
                  <Slash />
                </BreadcrumbSeparator>
                <BreadcrumbItem>
                  <BreadcrumbLink className="text-black font-semibold">
                    {route}
                  </BreadcrumbLink>
                </BreadcrumbItem>
              </>
            )}
          </BreadcrumbList>
        </Breadcrumb>
      </div>
    </section>
  );
}
