import {
  Pagination,
  PaginationContent,
  PaginationItem,
  PaginationLink,
  PaginationNext,
  PaginationPrevious,
} from "@/components/ui/pagination";
import clsx from "clsx";
import { GoArrowLeft } from "react-icons/go";

export default function CustomPagination() {
  return (
    <Pagination dir="ltr" className="mb-14 space-x-2">
      {/* Previous Button */}* - Previous button is disabled on the first page.
      * - Next button is disabled on the last page. * - Highlights the current
      page link. */
      {currentPage == 1 ? (
        <div
          className="rounded-full border p-0  flex items-center justify-center opacity-75 border-dark"
          style={{ width: "2.5rem", height: "2.5rem" }}
          disabled={currentPage == 1}
        >
          <GoArrowLeft className="size-5 font-normal" />
        </div>
      ) : (
        <PaginationPrevious
          className="rounded-full border p-0 border-dark"
          href={`?page=${currentPage + 1}`}
          style={{ width: "2.5rem", height: "2.5rem" }}
          disabled={currentPage == 1}
        />
      )}
      {/* Pagination Links */}
      <PaginationContent>
        {Array.from({ length: totalPages }).map((_, index) => (
          <PaginationItem key={index}>
            <PaginationLink
              href={`?page=${index + 1}`}
              style={{ width: "2.5rem", height: "2.5rem" }}
              className={clsx("rounded-full bg-white border", {
                "bg-main text-white hover:bg-main hover:text-white":
                  index + 1 === currentPage,
              })}
            >
              {index + 1}
            </PaginationLink>
          </PaginationItem>
        ))}
      </PaginationContent>
      {/* Next Button */}
      <PaginationNext
        className="rounded-full border p-0 border-dark  shrink-0"
        href={`?page=${currentPage + 1}`}
        style={{ width: "2.5rem", height: "2.5rem" }}
        disabled={currentPage == totalPages}
      />
    </Pagination>
  );
}
