"use client";
import { useSettings } from "@/stores/settings";
import Image from "next/image";
import { useState } from "react";
export default function FallbackImage({ src = "", alt, ...props }) {
  const [imgError, setImgError] = useState(false);
  const { settings } = useSettings();

  return (
    <Image
      unoptimized
      src={
        imgError
          ? settings?.images?.not_found
          : src ?? "/products/Placeholder.png"
      }
      alt={alt}
      onError={() => setImgError(true)}
      {...props}
    />
  );
}
