import { getTranslations } from "next-intl/server";
import Link from "next/link";
import { FaArrowRight } from "react-icons/fa";
import FallbackImage from "../FallbackImage";

const LightBlueBlogCard = async ({ blog }) => {
  const t = await getTranslations("single-article");
  return (
    <div className="bg-white hover:bg-lightmain hover:scale-105 hover:shadow transition-all duration-300 rounded-xl overflow-hidden">
      <div className="">
        <FallbackImage
          width={600}
          height={300}
          src={blog.image}
          alt={blog.title}
          className="object-cover w-full h-36 md:h-64"
        />
      </div>
      <div className=" p-3 md:p-6 space-y-4">
        <div className="">
          <Link
            href={`/articles/${blog.id}`}
            className="text-xl font-bold line-clamp-1 hover:text-main"
          >
            {blog.title}
          </Link>
        </div>
        <div
          className="line-clamp-2 text-secondary leading-loose"
          dangerouslySetInnerHTML={{
            __html: blog.excerpt || "", // Ensure content is not undefined
          }}
        ></div>
        {/* </p> */}
        <div className="flex items-center justify-between ">
          {/* link */}
          <Link
            href={`/articles/${blog.id}`}
            className="btn btn-btnColor flex  items-center gap-2 text-sm font-bold rounded-full"
          >
            <FaArrowRight size={16} />
            {t("readMore")}
          </Link>
        </div>
      </div>
    </div>
  );
};

export default LightBlueBlogCard;
