import { useLocale } from "next-intl";
import Link from "next/link";
import { LuChevronRight, LuChevronLeft } from "react-icons/lu";

const LightBlueSectionHeader = ({
  title = "",
  marker = "",
  withLink = true,
  link = "#"
}) => {
  const locale = useLocale();

  return (
    // REDESIGN THEME
    <div className="mt-5  xl:mt-10 2xl:mt-20">
      <div className="flex flex-col   gap-2">
        <h2 className="text-black font-semibold md:text-xl 2xl:text-3xl p-0">
          {title}{" "}{marker}
        </h2>
        <div className="h-[1px] bg-gray-300 w-[95%]  grow"></div>
        {withLink ? (
          locale == "ar" ?
            <Link
              href={link}
              className="flex items-center gap-1 text-secondary hover:text-main p-0"
            >
              عرض الكل
              <LuChevronLeft size={22} className="" />
            </Link> :
            <Link
              href={link}
              className="flex items-center gap-1 text-secondary hover:text-main p-0"
            >
              View All
              <LuChevronRight size={22} className="text-main" />
            </Link>
        ) : null}
      </div>
    </div>

    // LIGHT BLUE THEME
    // <div className="my-2">
    //   <div className="  flex items-center justify-between gap-2">  
    //     <h2 className="text-secondary md:text-xl p-0">
    //       {title}{" "}
    //       <span className="relative text-main font-semibold p-0">
    //         {marker}
    //       </span>
    //     </h2>
    //     <div className="h-[1px] bg-secondary bg-opacity-50 grow"></div>
    //     {withLink ? (
    //       locale == "ar" ?
    //         <Link
    //           href={link}
    //           className="flex items-center gap-1 text-secondary hover:text-main p-0"
    //         >
    //           عرض الكل
    //           <LuChevronLeft size={22} className="text-main" />
    //         </Link> :
    //         <Link
    //           href={link}
    //           className="flex items-center gap-1 text-secondary hover:text-main p-0"
    //         >
    //           View All
    //           <LuChevronRight size={22} className="text-main" />
    //         </Link>
    //     ) : null}
    //   </div>
    // </div>
  );
};

export default LightBlueSectionHeader;
