"use client";
import useCart from "@/stores/cart";
import { useCurrency } from "@/stores/currency-state";
import { useTranslations } from "next-intl";
import Link from "next/link";
import { useState } from "react";
import { IoStar } from "react-icons/io5";
import FallbackImage from "../FallbackImage";
import { getToken } from "@/actions/cookies";

export default function LightBlueSideProductCard({ product }) {
  const { currencyShortname, rate } = useCurrency();
  const [isPending, setIsPending] = useState(false);
  const { addToCart: addToCartLocal, updateCart } = useCart();
  const t = useTranslations("cart");
  // Add to cart
  // const handleAddToCart = async () => {
  //   setIsPending(true);
  // const token = await getToken();
  // if (token) {
  //     const { message, code } = await addToCart(product.id);
  //     setIsPending(false);
  //     if (code !== 200) {
  //       toastError(message || t("add-fail"));
  //       return;
  //     }
  //     updateCart();
  //     toastSuccess(message || t("add-success"));
  //   } else {
  //     setIsPending(false);
  //     addToCartLocal(product);
  //     toastSuccess(t("add-success"));
  //   }
  // };
  return (
    <div className="col-span-12 ">
      <div className="flex items-center gap-2  relative">
        <Link href={`/products/${product.id}`} className="block">
          <FallbackImage
            src={product.cover_photo}
            alt={product.title}
            width={75}
            height={75}
          />
        </Link>
        <div className="flex items-center  justify-between w-full">
          <Link href={`/products/${product.id}`} className="space-y-2">
            <h3 className=" font-semibold line-clamp-1">{product.title}</h3>
            <p className=" font-bold space-x-2">
              <span className="text-main">{currencyShortname}</span>{" "}
              {parseFloat(
                (product.price - product.price * (product.discount / 100)) *
                rate
              ).toFixed(2)}{" "}
              {product.discount ? (
                <del className="text-sm text-gray-400">
                  {parseFloat(product.price * rate).toFixed(2)}
                </del>
              ) : null}
            </p>
            {product.rate && (
              <div className="flex items-center gap-1 justify-center">
                {Array.from({ length: Math.floor(product.rate) }, (_, i) => (
                  <IoStar
                    key={`yellow-${i}`}
                    size={16}
                    className="text-yellow-400"
                  />
                ))}
                {Array.from(
                  { length: 5 - Math.floor(product.rate) },
                  (_, i) => (
                    <IoStar
                      key={`gray-${i}`}
                      size={16}
                      className="text-gray-300"
                    />
                  )
                )}
                <p className="text-sm font-semibold pt-1">
                  {parseFloat(product.rate).toFixed(1)}
                </p>
              </div>
            )}
          </Link>
          {/* Add to cart button */}
          {/* <button
            disabled={isPending}
            onClick={handleAddToCart}
            className=" size-8 absolute bottom-0 end-0   btn btn-main p-0 rounded-full  flex items-center justify-center self-end"
          >
            {isPending ? (
              <Loader2 size={20} className="text-[#FEC958] animate-spin  " />
            ) : (
              <>
                <GoPlus size={20} className="text-[#FEC958] " />
              </>
            )}
          </button> */}
        </div>
      </div>
    </div>
  );
}
