import fetchData from "@/api/fetch-data";
import { getLocale } from "next-intl/server";

import MainSectionUiRedesignTwo from "./MainSectionUiRedesignTwo";

export default async function MainSectionRedesignTwo({
  sectionType,
  title,
  displayTitle,
  published,
  styles,
  iconColor,
  sectionId,
}) {
  const locale = await getLocale();
  let productsData = [];
  // handled title and marker
  const words = title?.trim().split(" ");
  const lastWord = words?.pop();
  const restOfTitle = words?.join(" ");
  if (published == "1") {
    const response = await fetchData({
      endPoint: `/sections/${sectionType}`,
      locale: locale,
    });
    if (response.status == "success") {
      productsData = response.data[0].products;
    }
  }
  if (productsData.length > 0) {
    return published == "1" ? (
      <MainSectionUiRedesignTwo
        sectionId={sectionId}
        displayTitle={displayTitle}
        title={restOfTitle}
        marker={lastWord}
        productsData={productsData}
        styles={styles}
        iconColor={iconColor}
      />
    ) : null;
  }
  return null;
}
